/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PreDestroy;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.HttpUpgradeHandler;
import org.eclipse.jetty.ee8.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee8.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.ee8.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.ee8.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.ee8.webapp.MetaData;
import org.eclipse.jetty.ee8.webapp.Origin;
import org.eclipse.jetty.ee8.webapp.WebAppContext;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    public void doHandle(Class clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PreDestroy.class)) continue;
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException(String.valueOf(m) + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(String.valueOf(m) + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(String.valueOf(m) + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(String.valueOf(m) + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("pre-destroy");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, m.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", (Object)lifecycles);
                }
                lifecycles.add((LifeCycleCallback)callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

