/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class JDTModifiedDeclaration
implements ModifiedDeclaration {
    private final Adapter adapter;
    protected static final Predicate<IExtendedModifier> EXTENDED_MODIFIER_IS_ANNOTATION = new ExtendedModifierIsAnnotation();

    public JDTModifiedDeclaration(Adapter adapter) {
        this.adapter = adapter;
    }

    public JDTModifiedDeclaration(BodyDeclaration declaration) {
        this(new BodyDeclarationAdapter(declaration));
    }

    public JDTModifiedDeclaration(PackageDeclaration declaration) {
        this(new PackageDeclarationAdapter(declaration));
    }

    public JDTModifiedDeclaration(SingleVariableDeclaration declaration) {
        this(new SingleVariableDeclarationAdapter(declaration));
    }

    public JDTModifiedDeclaration(VariableDeclarationExpression declaration) {
        this(new VariableDeclarationExpressionAdapter(declaration));
    }

    public JDTModifiedDeclaration(VariableDeclarationStatement declaration) {
        this(new VariableDeclarationStatementAdapter(declaration));
    }

    @Override
    public Annotation getAnnotationNamed(String annotationName) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!this.annotationIsNamed(annotation, annotationName)) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public void removeAnnotationNamed(String annotationName) {
        Iterator<IExtendedModifier> stream = this.getModifiers().iterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = stream.next();
            if (!modifier.isAnnotation() || !this.annotationIsNamed((Annotation)modifier, annotationName)) continue;
            stream.remove();
            break;
        }
    }

    @Override
    public void replaceAnnotationNamed(String oldAnnotationName, Annotation newAnnotation) {
        List<IExtendedModifier> modifiers = this.getModifiers();
        ListIterator<IExtendedModifier> stream = modifiers.listIterator();
        while (stream.hasNext()) {
            IExtendedModifier modifier = stream.next();
            if (!modifier.isAnnotation() || !this.annotationIsNamed((Annotation)modifier, oldAnnotationName)) continue;
            stream.set((IExtendedModifier)newAnnotation);
            return;
        }
        this.addAnnotation(newAnnotation);
    }

    protected void addAnnotation(Annotation annotation) {
        List<IExtendedModifier> modifiers = this.getModifiers();
        ListIterator<IExtendedModifier> stream = modifiers.listIterator();
        while (stream.hasNext()) {
            if (!stream.next().isModifier()) continue;
            stream.previous();
            stream.add((IExtendedModifier)annotation);
            return;
        }
        modifiers.add((IExtendedModifier)annotation);
    }

    protected Iterable<Annotation> getAnnotations() {
        return IterableTools.downCast(this.getAnnotations_());
    }

    protected Iterable<IExtendedModifier> getAnnotations_() {
        return IterableTools.filter(this.getModifiers(), EXTENDED_MODIFIER_IS_ANNOTATION);
    }

    @Override
    public boolean addImport(String className) {
        if (className.indexOf(46) == -1) {
            return true;
        }
        return this.addImport(className, false);
    }

    @Override
    public boolean addStaticImport(String enumConstantName) {
        int index1 = enumConstantName.indexOf(46);
        if (index1 == -1) {
            throw new IllegalArgumentException(enumConstantName);
        }
        int index2 = enumConstantName.indexOf(46, index1 + 1);
        if (index2 == -1) {
            return true;
        }
        return this.addImport(enumConstantName, true);
    }

    @Override
    public boolean addImport(String importName, boolean staticImport) {
        Boolean include = this.importsInclude(importName, staticImport);
        if (include != null) {
            return include;
        }
        ImportDeclaration importDeclaration = this.getAst().newImportDeclaration();
        importDeclaration.setName(this.getAst().newName(importName));
        importDeclaration.setStatic(staticImport);
        this.getImports().add(importDeclaration);
        return true;
    }

    protected Boolean importsInclude(String importName, boolean staticImport) {
        int period = importName.lastIndexOf(46);
        String importNameQualifier = importName.substring(0, period);
        String shortImportName = importName.substring(period + 1);
        return this.importsInclude(importName, importNameQualifier, shortImportName, staticImport);
    }

    protected Boolean importsInclude(String importName, String importNameQualifier, String shortImportName, boolean staticImport) {
        for (ImportDeclaration importDeclaration : this.getImports()) {
            Boolean match;
            if (importDeclaration.isStatic() != staticImport || (match = this.importMatches(importDeclaration, importName, importNameQualifier, shortImportName)) == null) continue;
            return match;
        }
        return null;
    }

    protected Boolean importMatches(ImportDeclaration importDeclaration, String importName, String importNameQualifier, String shortImportName) {
        String idn = importDeclaration.getName().getFullyQualifiedName();
        if (importName.equals(idn)) {
            return Boolean.TRUE;
        }
        String shortIDN = idn.substring(idn.lastIndexOf(46) + 1);
        if (shortImportName.equals(shortIDN)) {
            return Boolean.FALSE;
        }
        if (importDeclaration.isOnDemand()) {
            if (importNameQualifier.equals(idn)) {
                return Boolean.TRUE;
            }
            if (importDeclaration.isStatic() ? this.enumResolves(idn, shortImportName) : this.typeResolves(idn + "." + shortImportName)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected boolean enumResolves(String enumTypeName, String enumConstantName) {
        try {
            return this.enumResolves_(enumTypeName, enumConstantName);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean enumResolves_(String enumTypeName, String enumConstantName) throws JavaModelException {
        IType jdtType = this.findType_(enumTypeName);
        if (jdtType == null) {
            return false;
        }
        if (!jdtType.isEnum()) {
            return false;
        }
        IField[] iFieldArray = jdtType.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField jdtField = iFieldArray[n2];
            if (jdtField.isEnumConstant() && jdtField.getElementName().equals(enumConstantName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean typeResolves(String name) {
        return this.findType(name) != null;
    }

    protected IType findType(String name) {
        try {
            return this.findType_(name);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected IType findType_(String name) throws JavaModelException {
        return this.getCompilationUnit().getJavaElement().getJavaProject().findType(name);
    }

    protected List<ImportDeclaration> getImports() {
        return this.imports(this.getCompilationUnit());
    }

    protected List<ImportDeclaration> imports(CompilationUnit astRoot) {
        return astRoot.imports();
    }

    @Override
    public boolean annotationIsNamed(Annotation annotation, String name) {
        return this.getQualifiedName(annotation).equals(name);
    }

    protected String getQualifiedName(Annotation annotation) {
        String resolvedName;
        ITypeBinding typeBinding = annotation.resolveTypeBinding();
        if (typeBinding != null && (resolvedName = typeBinding.getQualifiedName()) != null) {
            return resolvedName;
        }
        return this.convertToFullClassName(annotation.getTypeName().getFullyQualifiedName());
    }

    protected String convertToFullClassName(String name) {
        return name.lastIndexOf(46) != -1 ? name : this.resolveAgainstImports(name, false);
    }

    protected String convertToFullEnumConstantName(String name) {
        int index1 = name.indexOf(46);
        if (index1 == -1) {
            return this.resolveAgainstImports(name, true);
        }
        int index2 = name.indexOf(46, index1 + 1);
        if (index2 == -1) {
            return this.resolveAgainstImports(name, false);
        }
        return name;
    }

    protected String resolveAgainstImports(String shortName, boolean static_) {
        for (ImportDeclaration importDeclaration : this.getImports()) {
            String resolvedName;
            if (importDeclaration.isStatic() != static_ || (resolvedName = this.resolveAgainstImport(importDeclaration, shortName)) == null) continue;
            return resolvedName;
        }
        return shortName;
    }

    protected String resolveAgainstImport(ImportDeclaration importDeclaration, String shortName) {
        String idn = importDeclaration.getName().getFullyQualifiedName();
        if (importDeclaration.isOnDemand()) {
            String candidate = idn + "." + shortName;
            if (importDeclaration.isStatic() ? this.enumResolves(idn, shortName) : this.typeResolves(candidate)) {
                return candidate;
            }
            return null;
        }
        int period = idn.length() - shortName.length() - 1;
        if (period < 1) {
            return null;
        }
        if (idn.charAt(period) == '.' && idn.endsWith(shortName)) {
            return idn;
        }
        return null;
    }

    @Override
    public ASTNode getDeclaration() {
        return this.adapter.getDeclaration();
    }

    protected List<IExtendedModifier> getModifiers() {
        return this.adapter.getModifiers();
    }

    @Override
    public AST getAst() {
        return this.getDeclaration().getAST();
    }

    protected CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this.getDeclaration().getRoot();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.adapter.toString());
    }

    public static interface Adapter {
        public ASTNode getDeclaration();

        public List<IExtendedModifier> getModifiers();
    }

    public static class BodyDeclarationAdapter
    implements Adapter {
        private final BodyDeclaration declaration;

        public BodyDeclarationAdapter(BodyDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> getModifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.declaration.toString());
        }
    }

    protected static class ExtendedModifierIsAnnotation
    extends PredicateAdapter<IExtendedModifier> {
        protected ExtendedModifierIsAnnotation() {
        }

        public boolean evaluate(IExtendedModifier modifier) {
            return modifier.isAnnotation();
        }
    }

    public static class PackageDeclarationAdapter
    implements Adapter {
        private final PackageDeclaration declaration;

        public PackageDeclarationAdapter(PackageDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> getModifiers() {
            return this.declaration.annotations();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.declaration.toString());
        }
    }

    public static class SingleVariableDeclarationAdapter
    implements Adapter {
        private final SingleVariableDeclaration declaration;

        public SingleVariableDeclarationAdapter(SingleVariableDeclaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> getModifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.declaration.toString());
        }
    }

    public static class VariableDeclarationExpressionAdapter
    implements Adapter {
        private final VariableDeclarationExpression declaration;

        public VariableDeclarationExpressionAdapter(VariableDeclarationExpression declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> getModifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.declaration.toString());
        }
    }

    public static class VariableDeclarationStatementAdapter
    implements Adapter {
        private final VariableDeclarationStatement declaration;

        public VariableDeclarationStatementAdapter(VariableDeclarationStatement declaration) {
            this.declaration = declaration;
        }

        @Override
        public ASTNode getDeclaration() {
            return this.declaration;
        }

        @Override
        public List<IExtendedModifier> getModifiers() {
            return this.declaration.modifiers();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.declaration.toString());
        }
    }
}

