/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.ClientBehaviorRendererClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ClientBehaviorRendererType;
import org.eclipse.jst.jsf.facesconfig.emf.ClientBehaviorRendererTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.WriteRenderKitTestCase_1_2;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteRenderKitTestCase_2_0
extends WriteRenderKitTestCase_1_2 {
    private static final String RENDER_KIT_ID = CommonStructuresUtil.createPreficedString("render-kit20", "id");
    private static final String CLIENT_BEHAVIOR_RENDERER_TYPE = "client-behavior-renderer-type";
    private static final String CLIENT_BEHAVIOR_RENDERER_CLASS = "client-behavior-renderer-class";

    public WriteRenderKitTestCase_2_0(String name) {
        super(name);
    }

    public void testRenderKit20() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteRenderKitTestCase_2_0.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            RenderKitType renderKit = facesConfigFactory.createRenderKitType();
            renderKit.getDescription().add((Object)CommonStructuresUtil.createDescription("render-kit"));
            renderKit.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName("render-kit"));
            renderKit.getIcon().add((Object)CommonStructuresUtil.createIcon("render-kit"));
            ClientBehaviorRendererType clientBehaviorRenderer = facesConfigFactory.createClientBehaviorRendererType();
            renderKit.getClientBehaviorRenderer().add((Object)clientBehaviorRenderer);
            ClientBehaviorRendererTypeType clientBehaviorRendererType = facesConfigFactory.createClientBehaviorRendererTypeType();
            clientBehaviorRendererType.setTextContent(CLIENT_BEHAVIOR_RENDERER_TYPE);
            clientBehaviorRenderer.setClientBehaviorRendererType(clientBehaviorRendererType);
            ClientBehaviorRendererClassType clientBehaviorRendererClass = facesConfigFactory.createClientBehaviorRendererClassType();
            clientBehaviorRendererClass.setTextContent(CLIENT_BEHAVIOR_RENDERER_CLASS);
            clientBehaviorRenderer.setClientBehaviorRendererClass(clientBehaviorRendererClass);
            renderKit.setId(RENDER_KIT_ID);
            EList list = edit.getFacesConfig().getRenderKit();
            list.add((Object)renderKit);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteRenderKitTestCase_2_0.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteRenderKitTestCase_2_0.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getRenderKit(), RENDER_KIT_ID);
            WriteRenderKitTestCase_2_0.assertNotNull((Object)renderKit);
            WriteRenderKitTestCase_2_0.assertEquals((int)1, (int)renderKit.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription("render-kit", (DescriptionType)renderKit.getDescription().get(0));
            WriteRenderKitTestCase_2_0.assertEquals((int)1, (int)renderKit.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName("render-kit", (DisplayNameType)renderKit.getDisplayName().get(0));
            WriteRenderKitTestCase_2_0.assertEquals((int)1, (int)renderKit.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon("render-kit", (IconType)renderKit.getIcon().get(0));
            WriteRenderKitTestCase_2_0.assertEquals((int)1, (int)renderKit.getClientBehaviorRenderer().size());
            ClientBehaviorRendererType clientBehaviorRenderer = (ClientBehaviorRendererType)renderKit.getClientBehaviorRenderer().get(0);
            ClientBehaviorRendererTypeType clientBehaviorRendererType = clientBehaviorRenderer.getClientBehaviorRendererType();
            WriteRenderKitTestCase_2_0.assertEquals((String)CLIENT_BEHAVIOR_RENDERER_TYPE, (String)clientBehaviorRendererType.getTextContent());
            ClientBehaviorRendererClassType clientBehaviorRendererClass = clientBehaviorRenderer.getClientBehaviorRendererClass();
            WriteRenderKitTestCase_2_0.assertEquals((String)CLIENT_BEHAVIOR_RENDERER_CLASS, (String)clientBehaviorRendererClass.getTextContent());
            WriteRenderKitTestCase_2_0.assertEquals((String)RENDER_KIT_ID, (String)renderKit.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

