/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleEvent;
import org.eclipse.wst.common.project.facet.core.runtime.events.IRuntimeLifecycleListener;
import org.eclipse.wst.common.project.facet.core.runtime.events.internal.RuntimeLifecycleListenerRegistry;
import org.eclipse.wst.common.project.facet.core.runtime.events.internal.ValidationStatusChangedEvent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.Runtime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr;

public final class RuntimeManagerImpl {
    private static final String EXTENSION_ID = "runtimes";
    private static final String BRIDGES_EXTENSION_ID = "runtimeBridges";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VERSION = "version";
    private static final String EL_ADAPTER = "adapter";
    private static final String EL_BRIDGE = "bridge";
    private static final String EL_FACET = "facet";
    private static final String EL_FACTORY = "factory";
    private static final String EL_RUNTIME_COMPONENT = "runtime-component";
    private static final String EL_RUNTIME_COMPONENT_TYPE = "runtime-component-type";
    private static final String EL_RUNTIME_COMPONENT_VERSION = "runtime-component-version";
    private static final String EL_SUPPORTED = "supported";
    private static final String EL_UNSUPPORTED = "unsupported";
    private static final String EL_VERSION_COMPARATOR = "version-comparator";
    private static final String ANY = "any";
    private static final IndexedSet<String, IRuntimeComponentType> runtimeComponentTypes = new IndexedSet();
    private static final IndexedSet<String, IRuntime> runtimes = new IndexedSet();
    private static final List<Mapping> supportedMappings = new ArrayList<Mapping>();
    private static final List<Mapping> unsupportedMappings = new ArrayList<Mapping>();
    private static final Map<String, IRuntimeBridge> bridges = new HashMap<String, IRuntimeBridge>();
    private static final Set<IListener> listeners = new HashSet<IListener>();
    private static final RuntimeLifecycleListenerRegistry runtimeLifecycleListenerRegistry = new RuntimeLifecycleListenerRegistry();
    private static RuntimeValidationThread runtimeValidationThread = null;

    static {
        RuntimeManagerImpl.readMetadata();
        RuntimeManagerImpl.readBridgesExtensions();
    }

    private RuntimeManagerImpl() {
    }

    public static Set<IRuntimeComponentType> getRuntimeComponentTypes() {
        return runtimeComponentTypes.getItemSet();
    }

    public static boolean isRuntimeComponentTypeDefined(String id) {
        return runtimeComponentTypes.containsKey(id);
    }

    public static IRuntimeComponentType getRuntimeComponentType(String id) {
        IRuntimeComponentType rc = runtimeComponentTypes.getItemByKey(id);
        if (rc == null) {
            String msg = NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)id);
            throw new IllegalArgumentException(msg);
        }
        return rc;
    }

    public static IRuntimeComponent createRuntimeComponent(IRuntimeComponentVersion rcv, Map<String, String> properties) {
        RuntimeComponent rc = new RuntimeComponent();
        rc.setRuntimeComponentVersion(rcv);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                rc.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IRuntime> getRuntimes() {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            return new HashSet<IRuntime>(runtimes.getItemSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IRuntime> getRuntimes(Set<IProjectFacetVersion> facets) {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            HashSet<IRuntime> result = new HashSet<IRuntime>();
            for (IRuntime r : runtimes.getItemSet()) {
                boolean supports = true;
                for (IProjectFacetVersion fv : facets) {
                    if (r.supports(fv)) continue;
                    supports = false;
                    break;
                }
                if (!supports) continue;
                result.add(r);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRuntimeDefined(String name) {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            return runtimes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRuntime getRuntime(String name) {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            RuntimeManagerImpl.bridge();
            IRuntime runtime = runtimes.getItemByKey(name);
            if (runtime == null) {
                String msg = NLS.bind((String)Resources.runtimeNotDefined, (Object)name);
                throw new IllegalArgumentException(msg);
            }
            return runtime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRuntime defineRuntime(String name, List<IRuntimeComponent> components, Map<String, String> properties) {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            Runtime r = new Runtime();
            r.setName(name);
            for (IRuntimeComponent iRuntimeComponent : components) {
                r.addRuntimeComponent(iRuntimeComponent);
            }
            if (properties != null) {
                for (Map.Entry entry : properties.entrySet()) {
                    r.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            runtimes.addItemWithKey(r.getName(), r);
            RuntimeManagerImpl.notifyRuntimeListeners();
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRuntime(IRuntime runtime) {
        IndexedSet<String, IRuntime> indexedSet = runtimes;
        synchronized (indexedSet) {
            if (runtimes.removeItemByKey(runtime.getName())) {
                RuntimeManagerImpl.notifyRuntimeListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRuntimeListener(IListener listener) {
        Set<IListener> set = listeners;
        synchronized (set) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRuntimeListener(IListener listener) {
        Set<IListener> set = listeners;
        synchronized (set) {
            listeners.remove(listener);
        }
    }

    private static void notifyRuntimeListeners() {
        for (IListener listener : listeners) {
            try {
                listener.handle();
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(IRuntimeLifecycleListener listener, IRuntimeLifecycleEvent.Type ... types) {
        RuntimeLifecycleListenerRegistry runtimeLifecycleListenerRegistry = RuntimeManagerImpl.runtimeLifecycleListenerRegistry;
        synchronized (runtimeLifecycleListenerRegistry) {
            RuntimeManagerImpl.runtimeLifecycleListenerRegistry.addListener(listener, types);
            if (runtimeValidationThread == null) {
                runtimeValidationThread = new RuntimeValidationThread();
                runtimeValidationThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(IRuntimeLifecycleListener listener) {
        RuntimeLifecycleListenerRegistry runtimeLifecycleListenerRegistry = RuntimeManagerImpl.runtimeLifecycleListenerRegistry;
        synchronized (runtimeLifecycleListenerRegistry) {
            RuntimeManagerImpl.runtimeLifecycleListenerRegistry.removeListener(listener);
            if (runtimeValidationThread != null && RuntimeManagerImpl.runtimeLifecycleListenerRegistry.isEmpty()) {
                runtimeValidationThread.terminate();
                runtimeValidationThread = null;
            }
        }
    }

    static Set<IProjectFacetVersion> getSupportedFacets(List<IRuntimeComponent> composition) {
        HashSet<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>();
        for (IRuntimeComponent rc : composition) {
            for (Mapping m : supportedMappings) {
                try {
                    result.addAll(m.evaluate(rc));
                }
                catch (CoreException e) {
                    FacetCorePlugin.log(e.getStatus());
                }
                catch (VersionFormatException e) {
                    FacetCorePlugin.log(e);
                }
            }
        }
        for (IRuntimeComponent rc : composition) {
            for (Mapping m : unsupportedMappings) {
                try {
                    result.removeAll(m.evaluate(rc));
                }
                catch (CoreException e) {
                    FacetCorePlugin.log(e.getStatus());
                }
                catch (VersionFormatException e) {
                    FacetCorePlugin.log(e);
                }
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static void bridge() {
        modified = false;
        block4: for (Map.Entry<String, IRuntimeBridge> entry : RuntimeManagerImpl.bridges.entrySet()) {
            block9: {
                brid = entry.getKey();
                br = entry.getValue();
                existing = new HashMap<String, BridgedRuntime>();
                for (IRuntime r : RuntimeManagerImpl.runtimes.getItemSet()) {
                    if (!(r instanceof BridgedRuntime) || !(bridged = (BridgedRuntime)r).getBridgeId().equals(brid)) continue;
                    existing.put(bridged.getNativeRuntimeId(), bridged);
                }
                try {
                    exported = br.getExportedRuntimeNames();
                    break block9;
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)e);
                    ** for (r : existing.values())
                }
lbl-1000:
                // 1 sources

                {
                    RuntimeManagerImpl.runtimes.removeItemByKey(r.getName());
                    modified = true;
                    continue;
lbl21:
                    // 1 sources

                    continue block4;
                }
            }
            for (BridgedRuntime r : existing.values()) {
                if (exported.contains(r.getNativeRuntimeId())) continue;
                RuntimeManagerImpl.runtimes.removeItemByKey(r.getName());
                modified = true;
            }
            for (String id : exported) {
                if (existing.containsKey(id)) continue;
                try {
                    stub = br.bridge(id);
                    r = new BridgedRuntime(brid, id, stub);
                    r.setName(RuntimeManagerImpl.createUniqueRuntimeName(id));
                    RuntimeManagerImpl.runtimes.addItemWithKey(r.getName(), r);
                    modified = true;
                }
                catch (CoreException e) {
                    FacetCorePlugin.log((Exception)e);
                }
            }
            if (!modified) continue;
            RuntimeManagerImpl.notifyRuntimeListeners();
        }
    }

    private static String createUniqueRuntimeName(String suggestion) {
        String name = suggestion;
        int i = 1;
        while (runtimes.containsKey(name)) {
            name = String.valueOf(suggestion) + " (" + i + ")";
            ++i;
        }
        return name;
    }

    private static void readMetadata() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgel = iConfigurationElementArray[n4];
                cfgels.add(cfgel);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_RUNTIME_COMPONENT_TYPE)) continue;
            RuntimeManagerImpl.readRuntimeComponentType(config);
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_RUNTIME_COMPONENT_VERSION)) continue;
            RuntimeManagerImpl.readRuntimeComponentVersion(config);
        }
        RuntimeManagerImpl.calculateVersionComparisonTables();
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_ADAPTER)) continue;
            RuntimeManagerImpl.readAdapter(config);
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_SUPPORTED)) continue;
            RuntimeManagerImpl.readMapping(config, supportedMappings);
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_UNSUPPORTED)) continue;
            RuntimeManagerImpl.readMapping(config, unsupportedMappings);
        }
    }

    private static void readRuntimeComponentType(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return;
        }
        RuntimeComponentType rct = new RuntimeComponentType();
        rct.setId(id);
        rct.setPluginId(config.getContributor().getName());
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_VERSION_COMPARATOR)) {
                String clname = child.getAttribute(ATTR_CLASS);
                if (clname == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
                rct.setVersionComparator(clname);
            }
            ++i;
        }
        runtimeComponentTypes.addItemWithKey(id, rct);
    }

    private static void readRuntimeComponentVersion(IConfigurationElement config) {
        String type = config.getAttribute(ATTR_TYPE);
        if (type == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, ATTR_TYPE);
            return;
        }
        String ver = config.getAttribute(ATTR_VERSION);
        if (ver == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, ATTR_VERSION);
            return;
        }
        RuntimeComponentType rct = (RuntimeComponentType)runtimeComponentTypes.getItemByKey(type);
        if (rct == null) {
            String msg = String.valueOf(NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)type)) + NLS.bind((String)Resources.usedInPlugin, (Object)config.getContributor().getName());
            FacetCorePlugin.log(msg);
            return;
        }
        RuntimeComponentVersion rcv = new RuntimeComponentVersion();
        rcv.setRuntimeComponentType(rct);
        rcv.setVersionString(ver);
        rcv.setPluginId(config.getContributor().getName());
        rct.addVersion(rcv);
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateVersionComparisonTables() {
        ArrayList<IRuntimeComponentType> badRuntimeComponentTypes = new ArrayList<IRuntimeComponentType>();
        for (IRuntimeComponentType rct : runtimeComponentTypes.getItemSet()) {
            try {
                void var6_9;
                Comparator<String> comp = rct.getVersionComparator();
                ArrayList<IRuntimeComponentVersion> versions = new ArrayList<IRuntimeComponentVersion>(rct.getVersions());
                HashMap compTables = new HashMap();
                for (IRuntimeComponentVersion iRuntimeComponentVersion : versions) {
                    compTables.put(iRuntimeComponentVersion, new HashMap());
                }
                boolean bl = false;
                int n = versions.size();
                while (var6_9 < n) {
                    IRuntimeComponentVersion iVer = (IRuntimeComponentVersion)versions.get((int)var6_9);
                    String iVerStr = iVer.getVersionString();
                    Map iCompTable = (Map)compTables.get(iVer);
                    void j = var6_9 + true;
                    while (j < n) {
                        IRuntimeComponentVersion jVer = (IRuntimeComponentVersion)versions.get((int)j);
                        String jVerStr = jVer.getVersionString();
                        Map jCompTable = (Map)compTables.get(jVer);
                        int result = comp.compare(iVerStr, jVerStr);
                        iCompTable.put(jVer, new Integer(result));
                        jCompTable.put(iVer, new Integer(result * -1));
                        ++j;
                    }
                    ++var6_9;
                }
                for (Map.Entry entry : compTables.entrySet()) {
                    RuntimeComponentVersion rcv = (RuntimeComponentVersion)entry.getKey();
                    rcv.setComparisonTable((Map)entry.getValue());
                }
            }
            catch (Exception e) {
                FacetCorePlugin.log(e);
                badRuntimeComponentTypes.add(rct);
            }
        }
        for (IRuntimeComponentType rct : badRuntimeComponentTypes) {
            runtimeComponentTypes.removeItem(rct);
        }
    }

    private static void readAdapter(IConfigurationElement config) {
        IRuntimeComponentType rctype = null;
        IRuntimeComponentVersion rcversion = null;
        String factory = null;
        ArrayList<String> types = new ArrayList<String>();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_RUNTIME_COMPONENT)) {
                String id = child.getAttribute(ATTR_ID);
                if (id == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, ATTR_ID);
                    return;
                }
                if (!RuntimeManagerImpl.isRuntimeComponentTypeDefined(id)) {
                    String msg = String.valueOf(NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)id)) + NLS.bind((String)Resources.usedInPlugin, (Object)child.getContributor().getName());
                    FacetCorePlugin.log(msg);
                    return;
                }
                rctype = RuntimeManagerImpl.getRuntimeComponentType(id);
                String version = child.getAttribute(ATTR_VERSION);
                if (version != null) {
                    if (!rctype.hasVersion(version)) {
                        String msg = NLS.bind((String)Resources.runtimeComponentVersionNotDefined, (Object)id, (Object)version);
                        msg = String.valueOf(msg) + NLS.bind((String)Resources.usedInPlugin, (Object)config.getContributor().getName());
                        FacetCorePlugin.log(msg);
                        return;
                    }
                    rcversion = rctype.getVersion(version);
                }
            } else if (childName.equals(EL_FACTORY)) {
                factory = child.getAttribute(ATTR_CLASS);
                if (factory == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
            } else if (childName.equals(ATTR_TYPE)) {
                String type = child.getAttribute(ATTR_CLASS);
                if (type == null) {
                    RuntimeManagerImpl.reportMissingAttribute(child, ATTR_CLASS);
                    return;
                }
                types.add(type);
            }
            ++i;
        }
        Set<IRuntimeComponentVersion> versions = rcversion == null ? rctype.getVersions() : Collections.singleton(rcversion);
        String plugin = config.getContributor().getName();
        for (IRuntimeComponentVersion rcv : versions) {
            RuntimeComponentVersion v = (RuntimeComponentVersion)rcv;
            for (String type : types) {
                v.addAdapterFactory(type, plugin, factory);
            }
        }
    }

    private static void readMapping(IConfigurationElement config, List<Mapping> mappings) {
        Mapping m = new Mapping();
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            block11: {
                IRuntimeComponentType rct;
                IConfigurationElement child = children[i];
                String childName = child.getName();
                if (childName.equals(EL_FACET)) {
                    IProjectFacet f = RuntimeManagerImpl.readProjectFacetRef(child);
                    if (f != null) {
                        v = child.getAttribute(ATTR_VERSION);
                        expr = null;
                        if (v != null) {
                            try {
                                pluginId = config.getContributor().getName();
                                expr = new VersionExpr(f, v, pluginId);
                            }
                            catch (CoreException e) {
                                FacetCorePlugin.log(e.getStatus());
                                break block11;
                            }
                        }
                        m.facets.put(f, expr);
                    }
                } else if (childName.equals(EL_RUNTIME_COMPONENT) && child.getAttribute(ANY) == null && (rct = RuntimeManagerImpl.readRuntimeComponentTypeRef(child)) != null) {
                    v = child.getAttribute(ATTR_VERSION);
                    expr = null;
                    if (v != null) {
                        try {
                            pluginId = config.getContributor().getName();
                            expr = new VersionExpr(rct, v, pluginId);
                        }
                        catch (CoreException e) {
                            FacetCorePlugin.log(e.getStatus());
                            break block11;
                        }
                    }
                    m.runtimeComponents.put(rct, expr);
                }
            }
            ++i;
        }
        mappings.add(m);
    }

    private static void readBridgesExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.common.project.facet.core", BRIDGES_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        ArrayList<IConfigurationElement> cfgels = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgel = iConfigurationElementArray[n4];
                cfgels.add(cfgel);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement config : cfgels) {
            if (!config.getName().equals(EL_BRIDGE)) continue;
            String id = config.getAttribute(ATTR_ID);
            if (id == null) {
                RuntimeManagerImpl.reportMissingAttribute(config, ATTR_ID);
                return;
            }
            String clname = config.getAttribute(ATTR_CLASS);
            if (clname == null) {
                RuntimeManagerImpl.reportMissingAttribute(config, ATTR_CLASS);
                return;
            }
            String pluginId = config.getContributor().getName();
            IRuntimeBridge br = PluginUtil.instantiate(pluginId, clname, IRuntimeBridge.class);
            if (br == null) continue;
            bridges.put(id, br);
        }
    }

    private static IRuntimeComponentType readRuntimeComponentTypeRef(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return null;
        }
        if (!RuntimeManagerImpl.isRuntimeComponentTypeDefined(id)) {
            String msg = String.valueOf(NLS.bind((String)Resources.runtimeComponentTypeNotDefined, (Object)id)) + NLS.bind((String)Resources.usedInPlugin, (Object)config.getContributor().getName());
            FacetCorePlugin.log(msg);
            return null;
        }
        return RuntimeManagerImpl.getRuntimeComponentType(id);
    }

    private static IProjectFacet readProjectFacetRef(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            RuntimeManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return null;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
            ProblemLog.reportMissingFacet(id, config.getContributor().getName());
            return null;
        }
        return ProjectFacetsManager.getProjectFacet(id);
    }

    private static void reportMissingAttribute(IConfigurationElement el, String attribute) {
        Object[] params = new String[]{el.getContributor().getName(), el.getName(), attribute};
        String msg = NLS.bind((String)Resources.missingAttribute, (Object[])params);
        FacetCorePlugin.log(msg);
    }

    private static final class Mapping {
        public final Map<IProjectFacet, VersionExpr<ProjectFacetVersion>> facets = new HashMap<IProjectFacet, VersionExpr<ProjectFacetVersion>>();
        public final Map<IRuntimeComponentType, VersionExpr<RuntimeComponentVersion>> runtimeComponents = new HashMap<IRuntimeComponentType, VersionExpr<RuntimeComponentVersion>>();

        private Mapping() {
        }

        private Set<IProjectFacetVersion> evaluate(IRuntimeComponent rc) throws CoreException {
            VersionExpr<RuntimeComponentVersion> expr;
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            IRuntimeComponentVersion rcv = rc.getRuntimeComponentVersion();
            if (this.runtimeComponents.containsKey(rct) ? (expr = this.runtimeComponents.get(rct)) != null && !expr.check(rcv) : !this.runtimeComponents.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<IProjectFacetVersion> result = new HashSet<IProjectFacetVersion>();
            for (Map.Entry<IProjectFacet, VersionExpr<ProjectFacetVersion>> entry : this.facets.entrySet()) {
                IProjectFacet f = entry.getKey();
                VersionExpr<ProjectFacetVersion> expr2 = entry.getValue();
                for (IProjectFacetVersion fv : f.getVersions()) {
                    if (expr2 != null && !expr2.check(fv)) continue;
                    result.add(fv);
                }
            }
            return result;
        }
    }

    public static final class Resources
    extends NLS {
        public static String missingAttribute;
        public static String runtimeComponentTypeNotDefined;
        public static String runtimeComponentVersionNotDefined;
        public static String runtimeNotDefined;
        public static String usedInPlugin;

        static {
            Resources.initializeMessages((String)RuntimeManagerImpl.class.getName(), Resources.class);
        }
    }

    private static final class RuntimeValidationThread
    extends Thread {
        private boolean isAborted = false;
        private Map<String, IStatus> validationResults = new HashMap<String, IStatus>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IStatus getValidationResult(IRuntime runtime) {
            Map<String, IStatus> map = this.validationResults;
            synchronized (map) {
                return this.validationResults.get(runtime.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setValidationResult(IRuntime runtime, IStatus validationResult) {
            Map<String, IStatus> map = this.validationResults;
            synchronized (map) {
                this.validationResults.put(runtime.getName(), validationResult);
            }
        }

        @Override
        public void run() {
            while (!this.isAborted) {
                for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                    IStatus oldResult = this.getValidationResult(runtime);
                    IStatus newResult = runtime.validate((IProgressMonitor)new NullProgressMonitor());
                    if (oldResult != null && oldResult.getMessage().equals(newResult.getMessage())) continue;
                    this.setValidationResult(runtime, newResult);
                    ValidationStatusChangedEvent event = new ValidationStatusChangedEvent(runtime, oldResult, newResult);
                    runtimeLifecycleListenerRegistry.notifyListeners(event);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void terminate() {
            this.isAborted = true;
        }
    }
}

