/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResult;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.Invocation;
import org.easymock.internal.LegacyMatcherProvider;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.Result;
import org.easymock.internal.UnorderedBehavior;

public class MocksBehavior
implements IMocksBehavior,
Serializable {
    private static final long serialVersionUID = 3265727009370529027L;
    private final List<UnorderedBehavior> behaviorLists = new ArrayList<UnorderedBehavior>();
    private List<ExpectedInvocationAndResult> stubResults = new ArrayList<ExpectedInvocationAndResult>();
    private final boolean nice;
    private boolean checkOrder;
    private boolean isThreadSafe;
    private int position = 0;
    private volatile transient Thread lastThread;
    private LegacyMatcherProvider legacyMatcherProvider;

    public MocksBehavior(boolean nice) {
        this.nice = nice;
    }

    public final void addStub(ExpectedInvocation expected, Result result) {
        this.stubResults.add(new ExpectedInvocationAndResult(expected, result));
    }

    public void addExpected(ExpectedInvocation expected, Result result, Range count) {
        if (this.legacyMatcherProvider != null) {
            expected = expected.withMatcher(this.legacyMatcherProvider.getMatcher(expected.getMethod()));
        }
        this.addBehaviorListIfNecessary(expected);
        this.lastBehaviorList().addExpected(expected, result, count);
    }

    private final Result getStubResult(Invocation actual) {
        for (ExpectedInvocationAndResult each : this.stubResults) {
            if (!each.getExpectedInvocation().matches(actual)) continue;
            return each.getResult();
        }
        return null;
    }

    private void addBehaviorListIfNecessary(ExpectedInvocation expected) {
        if (this.behaviorLists.isEmpty() || !this.lastBehaviorList().allowsExpectedInvocation(expected, this.checkOrder)) {
            this.behaviorLists.add(new UnorderedBehavior(this.checkOrder));
        }
    }

    private UnorderedBehavior lastBehaviorList() {
        return this.behaviorLists.get(this.behaviorLists.size() - 1);
    }

    public final Result addActual(Invocation actual) {
        Result stubOrNice;
        int tempPosition = this.position;
        String errorMessage = "";
        while (this.position < this.behaviorLists.size()) {
            Result result = this.behaviorLists.get(this.position).addActual(actual);
            if (result != null) {
                return result;
            }
            errorMessage = errorMessage + this.behaviorLists.get(this.position).toString(actual);
            if (!this.behaviorLists.get(this.position).verify()) break;
            ++this.position;
        }
        if ((stubOrNice = this.getStubResult(actual)) == null && this.nice) {
            stubOrNice = Result.createReturnResult(RecordState.emptyReturnValueFor(actual.getMethod().getReturnType()));
        }
        this.position = tempPosition;
        if (stubOrNice != null) {
            return stubOrNice;
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)("\n  Unexpected method call " + actual.toString(MockControl.EQUALS_MATCHER) + ":" + errorMessage.toString())));
    }

    public void verify() {
        boolean verified = true;
        StringBuffer errorMessage = new StringBuffer();
        for (UnorderedBehavior behaviorList : this.behaviorLists.subList(this.position, this.behaviorLists.size())) {
            errorMessage.append(behaviorList.toString());
            if (behaviorList.verify()) continue;
            verified = false;
        }
        if (verified) {
            return;
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)("\n  Expectation failure on verify:" + errorMessage.toString())));
    }

    public void checkOrder(boolean value) {
        this.checkOrder = value;
    }

    public void makeThreadSafe(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public void checkCurrentThreadSameAsLastThread() {
        if (this.lastThread == null) {
            this.lastThread = Thread.currentThread();
        } else if (this.lastThread != Thread.currentThread()) {
            throw new AssertionErrorWrapper(new AssertionError((Object)"\n  Un-thread-safe mock called from multiple threads"));
        }
    }

    public LegacyMatcherProvider getLegacyMatcherProvider() {
        if (this.legacyMatcherProvider == null) {
            this.legacyMatcherProvider = new LegacyMatcherProvider();
        }
        return this.legacyMatcherProvider;
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        this.getLegacyMatcherProvider().setDefaultMatcher(matcher);
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        this.getLegacyMatcherProvider().setMatcher(method, matcher);
    }
}

