/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import org.eclipse.core.resources.IFile;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteRoot;

public class DesignerPaletteRootFactory {
    private static final int DEFAULT_PALETTE_SIZE = 125;
    private static final String PALETTE_DOCK_LOCATION = "DesignerPaletteRootFactory.Location";
    private static final String PALETTE_SIZE = "DesignerPaletteRootFactory.Size";
    private static final String PALETTE_STATE = "DesignerPaletteRootFactory.State";

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        DesignerPaletteRootFactory.getPreferenceStore().setDefault(PALETTE_DOCK_LOCATION, -1);
        DesignerPaletteRootFactory.getPreferenceStore().setDefault(PALETTE_STATE, -1);
        DesignerPaletteRootFactory.getPreferenceStore().setDefault(PALETTE_SIZE, 125);
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return DesignerPaletteRootFactory.getPreferenceStore().getInt(DesignerPaletteRootFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return DesignerPaletteRootFactory.getPreferenceStore().getInt(DesignerPaletteRootFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return DesignerPaletteRootFactory.getPreferenceStore().getInt(DesignerPaletteRootFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                DesignerPaletteRootFactory.getPreferenceStore().setValue(DesignerPaletteRootFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                DesignerPaletteRootFactory.getPreferenceStore().setValue(DesignerPaletteRootFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                DesignerPaletteRootFactory.getPreferenceStore().setValue(DesignerPaletteRootFactory.PALETTE_SIZE, width);
            }
        };
    }

    private static IPreferenceStore getPreferenceStore() {
        return PDPlugin.getDefault().getPreferenceStore();
    }

    public static PaletteRoot createPaletteRoot(IFile file) {
        return new DesignerPaletteRoot(file);
    }
}

