/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.preferences;

import junit.framework.Assert;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.Severity;

final class PrefTestUtil
extends Assert {
    PrefTestUtil() {
    }

    static void assertSeverityLevel(ELValidationPreferences prefs, int diagnosticId, int value) {
        String key = ELValidationPreferences.getKeyById((int)diagnosticId);
        Severity sev = prefs.getSeverity(key);
        int diagnosticSeverity = ELValidationPreferences.mapSeverityToDiag((String)sev.toString());
        PrefTestUtil.assertEquals((int)value, (int)diagnosticSeverity);
    }

    static void setByKey(Severity severity, ELValidationPreferences prefs) {
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_BOTH_OPERANDS_NULL, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_POSSIBLE_DIVISION_BY_ZERO, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_NO_AVAILABLE_TYPE_COERCION, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN, severity);
        prefs.setSeverity(ELValidationPreferences.TERNARY_OP_CHOICE_IS_ALWAYS_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN, severity);
        prefs.setSeverity(ELValidationPreferences.UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED, severity);
        prefs.setSeverity(ELValidationPreferences.CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING, severity);
        prefs.setSeverity(ELValidationPreferences.MEMBER_NOT_FOUND, severity);
        prefs.setSeverity(ELValidationPreferences.VARIABLE_NOT_FOUND, severity);
        prefs.setSeverity(ELValidationPreferences.MISSING_CLOSING_EXPR_BRACKET, severity);
        prefs.setSeverity(ELValidationPreferences.GENERAL_SYNTAX_ERROR, severity);
        prefs.setSeverity(ELValidationPreferences.EMPTY_EL_EXPRESSION, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_DOT_WITH_VALUEB_NULL, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY, severity);
        prefs.setSeverity(ELValidationPreferences.POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME, severity);
        prefs.setSeverity(ELValidationPreferences.BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE, severity);
    }

    static void assertSetByKey(Severity severity, ELValidationPreferences prefs) {
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_BOTH_OPERANDS_NULL));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_POSSIBLE_DIVISION_BY_ZERO));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_NO_AVAILABLE_TYPE_COERCION));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_CONSTANT_EXPRESSION_EVAL_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_EMPTY_ALWAYS_FALSE_ON_TYPE));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.TERNARY_OP_CHOICE_IS_ALWAYS_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.CANNOT_APPLY_OPERATOR_TO_METHOD_BINDING));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.MEMBER_NOT_FOUND));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.VARIABLE_NOT_FOUND));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.MISSING_CLOSING_EXPR_BRACKET));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.GENERAL_SYNTAX_ERROR));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.EMPTY_EL_EXPRESSION));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_DOT_WITH_VALUEB_NULL));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_DOT_WITH_DOTTED_KEY_SHOULD_USE_ARRAY));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_COMPARISON_WITH_ENUM_ALWAYS_SAME));
        PrefTestUtil.assertEquals((Object)severity, (Object)prefs.getSeverity(ELValidationPreferences.BINARY_OP_COMPARISON_OF_ENUMS_INCOMPATIBLE));
    }

    static void assertExpectedDefaults(ELValidationPreferences prefs) {
        PrefTestUtil.assertSeverityLevel(prefs, 0, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 1, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 2, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 3, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 4, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 5, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 6, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 7, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 8, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 9, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 10, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 11, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 12, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 13, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 14, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 15, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 16, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 17, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 18, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 19, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 20, 0);
        PrefTestUtil.assertSeverityLevel(prefs, 21, 4);
        PrefTestUtil.assertSeverityLevel(prefs, 22, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 23, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 24, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 25, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 26, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 27, 2);
        PrefTestUtil.assertSeverityLevel(prefs, 28, 4);
    }
}

