/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.V8ScriptAction;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditResultDialog;

public class PushChangesAction
extends V8ScriptAction {
    @Override
    protected void execute(List<? extends ScriptTargetMapping> filePairList, Shell shell, IWorkbenchPart workbenchPart) {
        LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter = PushChangesAction.createPositionHighlighter(workbenchPart);
        for (ScriptTargetMapping scriptTargetMapping : filePairList) {
            this.execute(scriptTargetMapping, shell, positionHighlighter);
        }
    }

    private void execute(ScriptTargetMapping filePair, final Shell shell, final LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter) {
        final PushChangesPlan plan = PushChangesPlan.create((ScriptTargetMapping)filePair);
        UpdatableScript.UpdateCallback callback = new UpdatableScript.UpdateCallback(){

            public void success(boolean resumed, Object report, UpdatableScript.ChangeDescription changeDescription) {
                ChromiumDebugPlugin.log((IStatus)new Status(0, "org.eclipse.wst.jsdt.chromium.debug.core", "Script has been successfully updated on remote: " + report));
            }

            public void failure(final String message, final UpdatableScript.Failure failure) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LiveEditResultDialog.SingleInput textInput = LiveEditResultDialog.createTextInput(message, plan, failure);
                        LiveEditResultDialog dialog = new LiveEditResultDialog(shell, textInput, positionHighlighter);
                        dialog.open();
                    }
                });
            }
        };
        plan.execute(false, callback, null);
    }

    public static LiveEditResultDialog.ErrorPositionHighlighter createPositionHighlighter(IWorkbenchPart workbenchPart) {
        if (!(workbenchPart instanceof ITextEditor)) {
            return null;
        }
        final ITextEditor textEditor = (ITextEditor)workbenchPart;
        return new LiveEditResultDialog.ErrorPositionHighlighter(){

            @Override
            public void highlight(int offset, int length) {
                textEditor.selectAndReveal(offset, length);
            }
        };
    }
}

