/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SwitchTest
extends AbstractRegressionTest {
    public SwitchTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SwitchTest.buildAllCompliancesTestSuite(SwitchTest.testClass());
    }

    public static Class testClass() {
        return SwitchTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.js", "switch(0) {\ncase 0.5 :\ncase 1 :\ncase 2 :\n}\n"}, "SUCCESS");
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.js", "var n = 1; \nswitch(n) {\ncase 1/2: \ncase 1/3: \ndefault: \n}\n"}, "SUCCESS");
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.js", "var n = '1'; \nswitch (n) {\ncase 1: \ncase 2: \n}"}, "SUCCESS");
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.js", "var n = 1.5; \nswitch (n) {\ncase 1/2: \ncase 1/3: \n}"}, "SUCCESS");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"p/X.js", "switch (n) {\ncase 1:\ncase 1:\ncase 2:\n}"}, "----------\n1. ERROR in p\\X.js (at line 2)\n\tcase 1:\n\t^^^^^^\nDuplicate case\n----------\n2. ERROR in p\\X.js (at line 3)\n\tcase 1:\n\t^^^^^^\nDuplicate case\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"p/X.js", "var n = \"hi\"; \nswitch(n) {\ncase 'hi':\ncase 'bye':\ncase \"hi\":\n}"}, "----------\n1. ERROR in p\\X.js (at line 3)\n\tcase 'hi':\n\t^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in p\\X.js (at line 5)\n\tcase \"hi\":\n\t^^^^^^^^^\nDuplicate case\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"p/X.js", "function f(k) {\n\tswitch(k) {\n\tcase 1/2:\n   case 1/3: \n\t}\n}"});
    }

    public void test008() {
        this.runConformTest(new String[]{"p/X.js", "/** @param Int k **/function f(k) {\n\tswitch(k) {\n\tcase 1/2:\n   case 1/3: \n\t}\n}"});
    }

    public void test009() {
        this.runConformTest(new String[]{"p/X.js", "/** @param Number k **/function f(k) {\n\tswitch(k) {\n\tcase 1/2:\n   case 1/3: \n\t}\n}"});
    }

    public void test010() {
        this.runConformTest(new String[]{"p/X.js", "/**\n * @param String k \n **/function f(k) {\n\tswitch(k) {\n\tcase 1/2:\n   case 1/3: \n\t}\n}"});
    }
}

