/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;

public final class SourceJoinTableAnnotation
extends SourceBaseTableAnnotation
implements JoinTableAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();
    private final InverseJoinColumnsAnnotationContainer inverseJoinColumnsContainer = new InverseJoinColumnsAnnotationContainer();

    public SourceJoinTableAnnotation(JavaResourceModel parent, AnnotatedElement element) {
        this(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public SourceJoinTableAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.joinColumnsContainer.initializeFromContainerAnnotation(astAnnotation);
        this.inverseJoinColumnsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.joinColumnsContainer.synchronize(astAnnotation);
        this.inverseJoinColumnsContainer.synchronize(astAnnotation);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildSchemaDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"schema");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> buildCatalogDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"catalog");
    }

    @Override
    protected String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getJoinColumns() {
        return this.joinColumnsContainer.getNestedAnnotations();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.joinColumnsContainer.getNestedAnnotationsSize();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.getNestedAnnotation(index);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.addNestedAnnotation(index);
    }

    JoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.buildNestedSourceJoinColumnAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildJoinColumnIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildJoinColumnIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        this.joinColumnsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        this.joinColumnsContainer.removeNestedAnnotation(index);
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getInverseJoinColumns() {
        return this.inverseJoinColumnsContainer.getNestedAnnotations();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.inverseJoinColumnsContainer.getNestedAnnotationsSize();
    }

    @Override
    public JoinColumnAnnotation inverseJoinColumnAt(int index) {
        return (JoinColumnAnnotation)this.inverseJoinColumnsContainer.getNestedAnnotation(index);
    }

    @Override
    public JoinColumnAnnotation addInverseJoinColumn(int index) {
        return (JoinColumnAnnotation)this.inverseJoinColumnsContainer.addNestedAnnotation(index);
    }

    JoinColumnAnnotation buildInverseJoinColumn(int index) {
        return SourceJoinColumnAnnotation.buildNestedSourceJoinColumnAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildInverseJoinColumnIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildInverseJoinColumnIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.inverseJoinColumnsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        this.inverseJoinColumnsContainer.removeNestedAnnotation(index);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinColumnsContainer.isEmpty() && this.inverseJoinColumnsContainer.isEmpty();
    }

    class InverseJoinColumnsAnnotationContainer
    extends SourceModel.AnnotationContainer<JoinColumnAnnotation> {
        InverseJoinColumnsAnnotationContainer() {
            super((SourceModel)SourceJoinTableAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "inverseJoinColumns";
        }

        protected String getElementName() {
            return "inverseJoinColumns";
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        protected JoinColumnAnnotation buildNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.buildInverseJoinColumn(index);
        }
    }

    class JoinColumnsAnnotationContainer
    extends SourceModel.AnnotationContainer<JoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
            super((SourceModel)SourceJoinTableAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "joinColumns";
        }

        protected String getElementName() {
            return "joinColumns";
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        protected JoinColumnAnnotation buildNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.buildJoinColumn(index);
        }
    }
}

