/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IAnnotationEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PFValidator;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowElementEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowLinkEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowNodeEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;

public class PageflowAnnotationUtil {
    public static void validatePageflow(GraphicalEditPart containerPart) {
        if (containerPart == null) {
            return;
        }
        for (PageflowElementEditPart element : containerPart.getChildren()) {
            if (element instanceof PFValidator) {
                ((PFValidator)((Object)element)).validate();
            }
            for (PageflowLinkEditPart link : element.getSourceConnections()) {
                link.validate();
            }
        }
    }

    public static void validatePage(PageflowNodeEditPart pagePart) {
        if (pagePart != null && pagePart.getParent() != null) {
            return;
        }
        String errorMessage = null;
        PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)pagePart);
        errorMessage = PageflowValidation.getInstance().getNotifyMessage((PageflowPage)pagePart.getModel());
        if (errorMessage != null) {
            PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)pagePart, errorMessage);
        } else {
            PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)pagePart);
        }
    }

    public static void validateLink(PageflowLinkEditPart linkPart) {
        if (linkPart != null && linkPart.getParent() != null) {
            String errorMessage = null;
            PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)linkPart);
            errorMessage = PageflowValidation.getInstance().isValidLink((PageflowLink)linkPart.getModel());
            if (errorMessage != null) {
                PageflowAnnotationUtil.addAnnotation((GraphicalEditPart)linkPart, errorMessage);
            } else {
                PageflowAnnotationUtil.removeAnnotation((GraphicalEditPart)linkPart);
            }
        }
    }

    private static void addAnnotation(GraphicalEditPart editPart, String message) {
        if (editPart != null && editPart instanceof IAnnotationEditPart) {
            Annotation annotation = new Annotation("org.eclipse.core.resources.problemmarker", false, message);
            ((IAnnotationEditPart)editPart).addAnnotation(annotation);
        }
    }

    private static void removeAnnotation(GraphicalEditPart editPart) {
        if (editPart != null && editPart instanceof IAnnotationEditPart) {
            ((IAnnotationEditPart)editPart).removeAnnotation();
        }
    }
}

