/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import org.eclipse.wst.validation.internal.ValMessages;

public class MessageSeveritySetting {
    private String _id;
    private String _label;
    private Severity _default;
    private Severity _current;

    public MessageSeveritySetting(String id, String label, Severity defaultSeverity) {
        this._id = id;
        this._label = label;
        this._default = defaultSeverity;
    }

    public int hashCode() {
        int h = 0;
        if (this._current != null) {
            h += this._current.getMarkerSeverity() * 1000;
        }
        if (this._id != null) {
            h += this._id.hashCode();
        }
        return h;
    }

    public String getLabel() {
        return this._label;
    }

    public Severity getDefault() {
        return this._default;
    }

    public Severity getCurrent() {
        if (this._current != null) {
            return this._current;
        }
        return this._default;
    }

    public String getId() {
        return this._id;
    }

    public boolean setCurrent(Severity severity) {
        if (this._current == severity) {
            return false;
        }
        this._current = severity;
        return true;
    }

    public String toString() {
        return String.valueOf(this._id) + " " + this.getCurrent().toString();
    }

    public MessageSeveritySetting copy() {
        MessageSeveritySetting ms = new MessageSeveritySetting(this._id, this._label, this._default);
        ms._current = this._current;
        return ms;
    }

    public static enum Severity {
        Error(ValMessages.SevError, 2),
        Warning(ValMessages.SevWarning, 1),
        Ignore(ValMessages.SevIgnore, 0);

        private String _severityLabel;
        private int _markerSeverity;

        private Severity(String label, int markerSeverity) {
            this._severityLabel = label;
            this._markerSeverity = markerSeverity;
        }

        public String toString() {
            return this._severityLabel;
        }

        public int getMarkerSeverity() {
            return this._markerSeverity;
        }
    }
}

