/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.section.ManagedBeanScopeTreeItem;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaClassUtils;
import org.eclipse.jst.jsf.facesconfig.ui.util.ManagedBeanUtil;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ISummaryDataSource;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.ManagedBeanClassSelectionPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.NewJavaClassPage;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.NewManagedBeanWizard;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.WizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ManagedBeanPropertyPage
extends WizardPage
implements ISummaryDataSource {
    private static final int DESCRIPTION_TEXT_HEIGHT = 60;
    private static final int DEFAULT_WIDTHHINT = 10;
    private Text managedBeanNameText;
    private Combo scopeCombo;
    private Text managedBeanDescriptionText;
    private String helpID = null;
    private IProject currentProject;
    private String defaultScope;

    public ManagedBeanPropertyPage(String defaultScope, IProject project) {
        super("ManagedBeanPropertyWizardPage");
        this.defaultScope = defaultScope;
        this.currentProject = project;
        this.setTitle(WizardMessages.ManagedBeanPropertyWizardPage_Title);
        this.setDescription(WizardMessages.ManagedBeanPropertyWizardPage_Description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        this.createGeneralSection(container);
        this.setControl((Control)container);
        this.setPageComplete(false);
        if (this.helpID != null) {
            EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), this.helpID);
        }
    }

    private void createGeneralSection(Composite container) {
        Group generalSection = new Group(container, 0);
        generalSection.setText(WizardMessages.ManagedBeanPropertyWizardPage_General);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        generalSection.setLayout((Layout)gl);
        GridData gridData = new GridData(768);
        generalSection.setLayoutData((Object)gridData);
        SWTUtils.createLabel((Composite)generalSection, (String)WizardMessages.ManagedBeanPropertyWizardPage_ManagedBeanName, (int)1);
        this.managedBeanNameText = SWTUtils.createTextBox((Composite)generalSection, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 10;
        this.managedBeanNameText.setLayoutData((Object)gd);
        this.managedBeanNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ManagedBeanPropertyPage.this.isValidManagedBeanName(true)) {
                    ManagedBeanPropertyPage.this.setPageComplete(true);
                } else {
                    ManagedBeanPropertyPage.this.setPageComplete(false);
                }
            }
        });
        SWTUtils.createLabel((Composite)generalSection, (String)WizardMessages.ManagedBeanPropertyWizardPage_ManagedBeanScope, (int)1);
        String[] items = ManagedBeanScopeTreeItem.scopeItems;
        if (this.currentProject != null && !JSFAppConfigUtils.isValidJSFProject((IProject)this.currentProject, (String)"2.0")) {
            items = ManagedBeanScopeTreeItem.scopeItemsPreJSF2;
        }
        this.scopeCombo = SWTUtils.createCombo((Composite)generalSection, (String[])items, (int)1);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 10;
        this.scopeCombo.setLayoutData((Object)gd);
        Label labelDesp = SWTUtils.createLabel((Composite)generalSection, (String)WizardMessages.ManagedBeanPropertyWizardPage_ManagedBeanDescription, (int)1);
        gd = new GridData(2);
        labelDesp.setLayoutData((Object)gd);
        this.managedBeanDescriptionText = SWTUtils.createTextBoxScrollable((Composite)generalSection, (int)1, (int)-1, (int)60);
    }

    private boolean isValidManagedBeanName(boolean reportError) {
        if (this.managedBeanNameText.getText().length() == 0) {
            if (reportError) {
                this.setErrorMessage(WizardMessages.ManagedBeanPropertyWizardPage_Warning_MissingManagedBeanName);
            }
            return false;
        }
        if (JavaClassUtils.hasIllegalCharacters(this.managedBeanNameText.getText())) {
            if (reportError) {
                this.setErrorMessage(WizardMessages.ManagedBeanPropertyWizardPage_Warning_InvalidManagedBeanName);
            }
            return false;
        }
        if (ManagedBeanUtil.isBeanDuplicate(this.currentProject, this.managedBeanNameText.getText())) {
            if (reportError) {
                this.setErrorMessage(WizardMessages.ManagedBeanPropertyWizardPage_Warning_DuplicateManagedBeanName);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.initialize();
    }

    private void initialize() {
        if (this.defaultScope != null && this.defaultScope.length() > 0) {
            this.scopeCombo.setText(this.defaultScope);
        } else {
            this.scopeCombo.setText("session");
        }
        if (((NewManagedBeanWizard)this.getWizard()).getSuggestedBeanName() != null) {
            this.managedBeanNameText.setText(((NewManagedBeanWizard)this.getWizard()).getSuggestedBeanName());
        } else {
            String beanName = this.getPreviousPage() instanceof ManagedBeanClassSelectionPage ? ((ManagedBeanClassSelectionPage)this.getPreviousPage()).getClassName() : ((NewJavaClassPage)this.getPreviousPage()).getTypeName();
            if ((beanName = beanName.substring(beanName.lastIndexOf(".") + 1)) != null && beanName.length() > 0) {
                beanName = String.valueOf(beanName.substring(0, 1).toLowerCase()) + beanName.substring(1);
                beanName = ManagedBeanUtil.getDefaultManagedBeanName(this.currentProject, beanName);
            } else {
                beanName = "";
            }
            this.managedBeanNameText.setText(beanName);
        }
    }

    @Override
    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{WizardMessages.NewJavaManagedBeanWizard_Summary_ManagedBeanName, this.getManagedBeanName()});
        data.add(new String[]{WizardMessages.NewJavaManagedBeanWizard_Summary_ManagedBeanScope, this.getManagedBeanScope()});
        data.add(new String[]{WizardMessages.NewJavaManagedBeanWizard_Summary_ClassName, this.getManagedBeanClass()});
        data.add(new String[]{WizardMessages.NewJavaManagedBeanWizard_Summary_Description, this.getManagedBeanDescription()});
        return data;
    }

    public String getManagedBeanName() {
        return this.managedBeanNameText.getText().trim();
    }

    public String getManagedBeanClass() {
        if (this.getPreviousPage() instanceof ManagedBeanClassSelectionPage) {
            return ((ManagedBeanClassSelectionPage)this.getPreviousPage()).getClassName();
        }
        if (this.getPreviousPage() instanceof NewJavaClassPage) {
            NewJavaClassPage newJavaClassPage = (NewJavaClassPage)this.getPreviousPage();
            StringBuffer buffer = new StringBuffer();
            if (newJavaClassPage.getPackageText() != null && newJavaClassPage.getPackageText().length() > 0) {
                buffer.append(newJavaClassPage.getPackageText());
                buffer.append(".");
            }
            buffer.append(newJavaClassPage.getTypeName());
            return buffer.toString();
        }
        return "";
    }

    public String getManagedBeanScope() {
        return this.scopeCombo.getText().trim();
    }

    public String getManagedBeanDescription() {
        return this.managedBeanDescriptionText.getText().trim();
    }
}

