/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.encoding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.dtd.core.internal.encoding.ByteReader;
import org.eclipse.wst.dtd.core.internal.encoding.NullMemento;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public abstract class AbstractResourceEncodingDetector
implements IResourceCharsetDetector {
    protected EncodingMemento fEncodingMemento;
    protected boolean fHeaderParsed;
    protected Reader fReader;

    private void createEncodingMemento(String detectedCharsetName) {
        this.fEncodingMemento = new EncodingMemento();
        this.fEncodingMemento.setJavaCharsetName(this.getAppropriateJavaCharset(detectedCharsetName));
        this.fEncodingMemento.setDetectedCharsetName(detectedCharsetName);
        this.fEncodingMemento.setAppropriateDefault(this.getSpecDefaultEncoding());
    }

    protected final void createEncodingMemento(String detectedCharsetName, String reason) {
        this.createEncodingMemento(detectedCharsetName);
    }

    protected final void ensureInputSet() {
        if (this.fReader == null) {
            throw new IllegalStateException("input must be set before use");
        }
    }

    private String getAppropriateJavaCharset(String detectedCharsetName) {
        Charset javaCharset;
        String result;
        block5: {
            result = null;
            result = CodedIO.checkMappingOverrides((String)detectedCharsetName);
            javaCharset = null;
            try {
                javaCharset = Charset.forName(detectedCharsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                if (result != null && result.equals(detectedCharsetName)) {
                    this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                if (result == null || !result.equals(detectedCharsetName)) break block5;
                this.fEncodingMemento.setInvalidEncoding(detectedCharsetName);
            }
        }
        if (javaCharset != null) {
            result = javaCharset.name();
            result = CodedIO.checkMappingOverrides((String)result);
        }
        return result;
    }

    public String getEncoding() throws IOException {
        return this.getEncodingMemento().getDetectedCharsetName();
    }

    public EncodingMemento getEncodingMemento() throws IOException {
        this.ensureInputSet();
        if (!this.fHeaderParsed) {
            this.parseInput();
            this.fHeaderParsed = true;
        }
        if (this.fEncodingMemento == null) {
            this.handleSpecDefault();
        }
        if (this.fEncodingMemento == null) {
            this.fEncodingMemento = new NullMemento();
        }
        return this.fEncodingMemento;
    }

    public abstract String getSpecDefaultEncoding();

    public EncodingMemento getSpecDefaultEncodingMemento() {
        this.resetAll();
        EncodingMemento result = null;
        String enc = this.getSpecDefaultEncoding();
        if (enc != null) {
            this.createEncodingMemento(enc, "DefaultsAssumedForEmptyInput");
            this.fEncodingMemento.setAppropriateDefault(enc);
            result = this.fEncodingMemento;
        }
        return result;
    }

    private void handleSpecDefault() {
        String encodingName = this.getSpecDefaultEncoding();
        if (encodingName != null) {
            this.fEncodingMemento = new EncodingMemento();
            this.fEncodingMemento.setJavaCharsetName(encodingName);
            this.fEncodingMemento.setAppropriateDefault(encodingName);
        }
    }

    protected abstract void parseInput() throws IOException;

    private void resetAll() {
        this.fReader = null;
        this.fHeaderParsed = false;
        this.fEncodingMemento = null;
    }

    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new ByteReader(inputStream);
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void set(IStorage iStorage) throws CoreException {
        this.resetAll();
        InputStream inputStream = iStorage.getContents();
        BufferedInputStream resettableStream = new BufferedInputStream(inputStream, 8192);
        ((InputStream)resettableStream).mark(8192);
        this.set(resettableStream);
    }

    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

