/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;

public abstract class AbstractXSLUITest {
    protected static IProject fTestProject;
    protected static boolean fTestProjectInitialized;
    protected static final String PROJECT_FILES = "projectfiles";
    protected static final String TEST_PROJECT_NAME = "xsltestfiles";

    @Before
    public void setUp() throws Exception {
        AbstractXSLUITest.getWorkspace().getRoot().delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.setupTestProjectFiles("org.eclipse.wst.xsl.ui.tests");
        fTestProject.refreshLocal(2, null);
    }

    protected void setupTestProjectFiles(String bundleId) throws CoreException, IOException, URISyntaxException {
        AbstractXSLUITest.getAndCreateProject();
        Bundle coreBundle = Platform.getBundle((String)bundleId);
        Enumeration e = coreBundle.getEntryPaths("/projectfiles");
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            URL url = coreBundle.getEntry(path);
            if (url.getFile().endsWith("/")) continue;
            String relativePath = path;
            url = FileLocator.resolve((URL)url);
            path = path.substring(PROJECT_FILES.length());
            IFile destFile = fTestProject.getFile(path);
            if (url.toExternalForm().startsWith("jar:file")) {
                InputStream source = FileLocator.openStream((Bundle)coreBundle, (IPath)new Path(relativePath), (boolean)false);
                if (destFile.exists()) {
                    destFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                destFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
                source.close();
                continue;
            }
            destFile.createLink(url.toURI(), 256, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = AbstractXSLUITest.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        AbstractXSLUITest.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        Assert.assertTrue((boolean)fTestProject.exists());
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        String projName = TEST_PROJECT_NAME;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (project.isAccessible()) {
            project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        AbstractXSLUITest.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

