/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.project;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProject {
    public static final char CLASS_SEPARATOR = '#';
    private int idInMillis = 0;
    private IProject project;
    private IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public TestProject() throws CoreException {
        this("");
    }

    public TestProject(String name) throws CoreException {
        String testProjectName = "JavaProj_" + Long.toString(System.currentTimeMillis()) + "_" + this.idInMillis++ + name;
        this.project = this.workspace().getRoot().getProject(testProjectName);
        if (this.project.isAccessible()) {
            this.project.delete(true, true, null);
        }
        IWorkspaceRunnable createProjectOperation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestProject.this.project.create(null);
                TestProject.this.project.open(null);
                TestProject.this.configureJavaProject();
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(createProjectOperation);
    }

    private void configureJavaProject() throws CoreException {
        this.javaProject = JavaCore.create((IProject)this.project);
        IFolder binFolder = this.createBinFolder();
        this.setJavaNature();
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(binFolder);
        this.addSystemLibraries();
    }

    public TestProject(IProject project) throws CoreException {
        if (project == null) {
            throw new NullPointerException("project should not be null");
        }
        this.project = project;
        this.javaProject = JavaCore.create((IProject)project);
        this.sourceFolder = this.findSourceFolder();
    }

    private IPackageFragmentRoot findSourceFolder() throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.javaProject.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot pfr = iPackageFragmentRootArray[n2];
            if (pfr.getKind() == 1) {
                return pfr;
            }
            ++n2;
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void addJar(String plugin, String jar) throws MalformedURLException, IOException, CoreException {
        Path result = this.findFileInPlugin(plugin, jar);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newLibraryEntry((IPath)result, null, null);
        this.setClasspath(newEntries);
    }

    public IPackageFragment createPackage(final String name) throws CoreException {
        final IPackageFragment[] createdPackage = new IPackageFragment[1];
        IWorkspaceRunnable createPackageRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (TestProject.this.sourceFolder == null) {
                    TestProject.this.sourceFolder = TestProject.this.createSourceFolder("src");
                }
                createdPackage[0] = TestProject.this.sourceFolder.createPackageFragment(name, false, null);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(createPackageRunnable);
        return createdPackage[0];
    }

    public IType createType(final IPackageFragment pack, final String cuName, String source) throws CoreException {
        final StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(source);
        final ICompilationUnit[] createdCu = new ICompilationUnit[1];
        IWorkspaceRunnable createCuRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                createdCu[0] = pack.createCompilationUnit(cuName, buf.toString(), false, null);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(createCuRunnable);
        return createdCu[0].getTypes()[0];
    }

    public Map<String, IType> createTypes(IPackageFragment pack, String source) throws Exception {
        HashMap<String, IType> types = new HashMap<String, IType>();
        int startPos = 0;
        while ((startPos = source.indexOf(35)) > -1) {
            int endPos = source.indexOf(35, startPos + 1);
            if (endPos == -1) {
                endPos = source.length();
            }
            String src = source.substring(startPos + 1, endPos);
            source = source.substring(endPos);
            String className = src.substring(0, src.indexOf(10)).replaceAll("\r", "").trim();
            src = src.substring(src.indexOf(10) + 1);
            types.put(className, this.createType(pack, String.valueOf(className) + ".java", src));
        }
        return types;
    }

    public void dispose() throws CoreException {
        JobUtils.waitForJobs();
        IWorkspaceRunnable disposeProjectRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    TestProject.this.project.refreshLocal(2, null);
                    TestProject.this.project.delete(true, true, null);
                }
                catch (ResourceException resourceException) {
                    return;
                }
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(disposeProjectRunnable);
    }

    public void close() throws CoreException {
        JobUtils.waitForJobs();
        IWorkspaceRunnable closeRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestProject.this.project.close(monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(closeRunnable);
    }

    private IFolder createBinFolder() throws CoreException {
        IFolder binFolder = this.project.getFolder("bin");
        binFolder.create(false, true, null);
        return binFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(description, null);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    public IPackageFragmentRoot createSourceFolder(final String name) throws CoreException {
        final IPackageFragmentRoot[] createdRoot = new IPackageFragmentRoot[1];
        IWorkspaceRunnable createRootRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFolder folder = TestProject.this.project.getFolder(name);
                folder.create(false, true, null);
                createdRoot[0] = TestProject.this.javaProject.getPackageFragmentRoot((IResource)folder);
                IClasspathEntry[] oldEntries = TestProject.this.javaProject.getRawClasspath();
                IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
                System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
                newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)createdRoot[0].getPath());
                TestProject.this.setClasspath(newEntries);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(createRootRunnable);
        this.sourceFolder = createdRoot[0];
        return this.sourceFolder;
    }

    private void addSystemLibraries() throws CoreException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.setClasspath(newEntries);
    }

    private Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
        Bundle pluginBundle = Platform.getBundle((String)plugin);
        URL jarURL = new URL(pluginBundle.getEntry("/"), file);
        URL localJarURL = FileLocator.toFileURL((URL)jarURL);
        return new Path(localJarURL.getPath());
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.sourceFolder;
    }

    public IContainer getSourceFolderContainer() {
        IResource res;
        block4: {
            res = this.getSourceFolder().getCorrespondingResource();
            if (res != null) break block4;
            return null;
        }
        try {
            IContainer retVal = (IContainer)res;
            return retVal;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public IFolder createFolder(String folderName) throws CoreException {
        ContractChecker.nullCheckParam((Object)folderName, (String)"folderName");
        final IFolder folder = this.project.getFolder(folderName);
        IWorkspaceRunnable createFolderRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                folder.create(false, true, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(createFolderRunnable);
        return folder;
    }

    public void assignProjectRootAsSourceFolder() throws CoreException {
        IClasspathEntry defaultSrcFolderEntry = JavaCore.newSourceEntry((IPath)this.project.getFullPath());
        IClasspathEntry[] oldCp = this.javaProject.getRawClasspath();
        IClasspathEntry[] newCp = new IClasspathEntry[oldCp.length + 1];
        System.arraycopy(oldCp, 0, newCp, 0, oldCp.length);
        newCp[newCp.length - 1] = defaultSrcFolderEntry;
        this.setClasspath(newCp);
        this.sourceFolder = TestProjectsUtils.getSourceFolder(this.project, "");
    }

    private IWorkspace workspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void setClasspath(final IClasspathEntry[] newClasspath) throws CoreException {
        IWorkspaceRunnable setClasspathRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestProject.this.javaProject.setRawClasspath(newClasspath, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(setClasspathRunnable);
        String log = "\n" + this.javaProject.getProject().getName() + "\n" + String.valueOf(this.javaProject.getRawClasspath().length) + "\n";
        int ii = 0;
        while (ii < this.javaProject.getRawClasspath().length) {
            log = String.valueOf(log) + this.javaProject.getRawClasspath()[ii].getPath().toString() + "\n";
            ++ii;
        }
        if (this.javaProject.getRawClasspath().length == 0) {
            log = String.valueOf(log) + "Classpath not initialized !\n";
        }
        ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(0, "testOutput", log));
    }

    public void setAptProcessingEnabled(final boolean enabled, final boolean enableReconcile) throws CoreException {
        IWorkspaceRunnable setProcessingRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AptConfig.setEnabled((IJavaProject)TestProject.this.javaProject, (boolean)enabled);
                AptConfig.setProcessDuringReconcile((IJavaProject)TestProject.this.javaProject, (boolean)enableReconcile);
                TestProject.this.javaProject.getProject().build(15, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(setProcessingRunnable);
    }

    public void build(final int kind) throws CoreException {
        IWorkspaceRunnable buildRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestProject.this.project.build(kind, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(buildRunnable);
    }

    public void refresh() throws CoreException {
        IWorkspaceRunnable refreshRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TestProject.this.getProject().refreshLocal(2, monitor);
            }
        };
        TestProjectsUtils.executeWorkspaceRunnable(refreshRunnable);
    }
}

