/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationListIterableTests
extends TestCase {
    static final Transformer<String, Integer> STRING_LENGTH_TRANSFORMER = new StringLengthTransformer();

    public TransformationListIterableTests(String name) {
        super(name);
    }

    public void testTransform() {
        int i = 1;
        for (Integer integer : this.buildIterable()) {
            TransformationListIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable() {
        return this.buildTransformationListIterable(this.buildNestedList());
    }

    private Iterable<Integer> buildTransformationListIterable(List<String> nestedList) {
        return IterableTools.transform(nestedList, STRING_LENGTH_TRANSFORMER);
    }

    private List<String> buildNestedList() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    public void testToString() {
        TransformationListIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    public void testMissingTransformer() {
        Iterable iterable = IterableTools.transform(this.buildNestedList(), (Transformer)DisabledTransformer.instance());
        boolean exCaught = false;
        try {
            int i = 1;
            for (Integer integer : iterable) {
                TransformationListIterableTests.assertEquals((int)i++, (int)integer);
            }
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        TransformationListIterableTests.assertTrue((boolean)exCaught);
    }

    static class StringLengthTransformer
    extends TransformerAdapter<String, Integer> {
        StringLengthTransformer() {
        }

        public Integer transform(String s) {
            return new Integer(s.length());
        }
    }
}

