/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.ExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.command.DefaultCommandContext;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalExtendedCommandContext;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class CommandContextTests
extends MultiThreadedTestCase {
    public CommandContextTests(String name) {
        super(name);
    }

    public void testDefaultCommandExecutor_toString() throws Exception {
        CommandContext commandContext = DefaultCommandContext.instance();
        CommandContextTests.assertNotNull((Object)commandContext.toString());
    }

    public void testDefaultCommandExecutor_serialization() throws Exception {
        CommandContext commandContext1 = DefaultCommandContext.instance();
        CommandContext commandContext2 = TestTools.serialize(commandContext1);
        CommandContextTests.assertSame((Object)commandContext1, (Object)commandContext2);
    }

    public void testDefaultCommandContext() {
        TestCommand testCommand = new TestCommand();
        CommandContextTests.assertEquals((int)0, (int)testCommand.count);
        CommandContext commandContext = DefaultCommandContext.instance();
        commandContext.execute((Command)testCommand);
        CommandContextTests.assertEquals((int)1, (int)testCommand.count);
    }

    public void testThreadLocalCommandContext_toString() throws Exception {
        ThreadLocalExtendedCommandContext commandContext = new ThreadLocalExtendedCommandContext();
        CommandContextTests.assertNotNull((Object)commandContext.toString());
    }

    public void testThreadLocalCommandContext() throws Exception {
        ThreadLocalExtendedCommandContext threadLocalCommandContext = new ThreadLocalExtendedCommandContext();
        TestRunnable testRunnable1 = new TestRunnable(threadLocalCommandContext, 1);
        Thread thread1 = this.buildThread(testRunnable1);
        thread1.run();
        TestRunnable testRunnable2 = new TestRunnable(threadLocalCommandContext, 2);
        Thread thread2 = this.buildThread(testRunnable2);
        thread2.run();
        TestRunnable testRunnable3 = new TestRunnable(threadLocalCommandContext, 3, null);
        Thread thread3 = this.buildThread(testRunnable3);
        thread3.run();
        thread1.join();
        thread2.join();
        thread3.join();
        CommandContextTests.assertEquals((int)1, (int)testRunnable1.testCommand.count);
        CommandContextTests.assertEquals((int)1, (int)testRunnable1.testCommandContext.count);
        CommandContextTests.assertEquals((int)2, (int)testRunnable2.testCommand.count);
        CommandContextTests.assertEquals((int)2, (int)testRunnable2.testCommandContext.count);
        CommandContextTests.assertEquals((int)3, (int)testRunnable3.testCommand.count);
        CommandContextTests.assertNull((Object)testRunnable3.testCommandContext);
    }

    static class TestCommand
    implements Command {
        int count = 0;

        TestCommand() {
        }

        public void execute() {
            ++this.count;
        }
    }

    static class TestCommandContext
    implements ExtendedCommandContext {
        int count = 0;

        TestCommandContext() {
        }

        public void execute(Command command) {
            ++this.count;
            command.execute();
        }

        public void waitToExecute(Command command) {
            this.execute(command);
        }

        public boolean waitToExecute(Command command, long timeout) {
            this.execute(command);
            return true;
        }
    }

    static class TestRunnable
    implements Runnable {
        final ThreadLocalExtendedCommandContext threadLocalCommandContext;
        final int executionCount;
        final TestCommand testCommand = new TestCommand();
        final TestCommandContext testCommandContext;

        TestRunnable(ThreadLocalExtendedCommandContext threadLocalCommandContext, int executionCount) {
            this(threadLocalCommandContext, executionCount, new TestCommandContext());
        }

        TestRunnable(ThreadLocalExtendedCommandContext threadLocalCommandContext, int executionCount, TestCommandContext testCommandContext) {
            this.threadLocalCommandContext = threadLocalCommandContext;
            this.executionCount = executionCount;
            this.testCommandContext = testCommandContext;
        }

        @Override
        public void run() {
            this.threadLocalCommandContext.set((CommandContext)this.testCommandContext);
            int i = 0;
            while (i < this.executionCount) {
                this.threadLocalCommandContext.execute((Command)this.testCommand);
                ++i;
            }
        }
    }
}

