/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.table;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableCellLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableLayout2;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableCellInfo;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;

class TableOperationContext {
    private ElementEditPart _tablePart;
    private int _rowIndex;
    private int _columnIndex;

    TableOperationContext() {
    }

    public static TableOperationContext getTableOperationContext(EditPart part) {
        IFigure figure;
        EditPart originalPart = part;
        ElementEditPart tablePart = null;
        CSSTableLayout2 tableLayout = null;
        while (part.getParent() instanceof ElementEditPart) {
            figure = ((GraphicalEditPart)(part = part.getParent())).getFigure();
            if (!(figure.getLayoutManager() instanceof CSSTableLayout2)) continue;
            tableLayout = (CSSTableLayout2)figure.getLayoutManager();
            tablePart = (ElementEditPart)part;
            break;
        }
        if (tablePart == null) {
            return null;
        }
        part = originalPart;
        figure = ((GraphicalEditPart)originalPart).getFigure();
        while (figure instanceof CSSFigure) {
            if (figure.getLayoutManager() instanceof CSSTableCellLayout) {
                CSSTableCellLayout cellLayout = (CSSTableCellLayout)figure.getLayoutManager();
                if (cellLayout.getTableLayout() == tableLayout) {
                    TableCellInfo cellInfo = cellLayout.getTableCellInfo();
                    if (cellInfo == null) {
                        return null;
                    }
                    TableOperationContext context = new TableOperationContext();
                    context._tablePart = tablePart;
                    context._rowIndex = cellInfo.getRowIndex();
                    context._columnIndex = cellInfo.getColumnIndex();
                    return context;
                }
                return null;
            }
            figure = figure.getParent();
        }
        return null;
    }

    ElementEditPart getTablePart() {
        return this._tablePart;
    }

    int getRowIndex() {
        return this._rowIndex;
    }

    int getColumnIndex() {
        return this._columnIndex;
    }
}

