/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.ContentTypeReference;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.JptResourceTypeManager;
import org.eclipse.jpt.common.core.internal.InternalJptResourceType;
import org.eclipse.jpt.common.core.internal.InternalJptWorkspace;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class InternalJptResourceTypeManager
implements JptResourceTypeManager {
    private final InternalJptWorkspace jptWorkspace;
    private final ArrayList<InternalJptResourceType> resourceTypes = new ArrayList();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "resourceTypes";
    private static final String RESOURCE_TYPE_ELEMENT = "resource-type";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CONTENT_TYPE_ATTRIBUTE = "content-type";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String BASE_TYPE_ELEMENT = "base-type";

    public InternalJptResourceTypeManager(InternalJptWorkspace jptWorkspace) {
        this.jptWorkspace = jptWorkspace;
        this.initialize();
    }

    private void initialize() {
        int n;
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        ArrayList<IConfigurationElement> resourceTypeElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n2 = iExtensionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IExtension extension = iExtensionArray[n3];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            n = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(RESOURCE_TYPE_ELEMENT)) {
                    resourceTypeElements.add(element);
                }
                ++n4;
            }
            ++n3;
        }
        LinkedList<SimpleAssociation> stubs = new LinkedList<SimpleAssociation>();
        for (IConfigurationElement element : resourceTypeElements) {
            InternalJptResourceType resourceType = this.buildResourceType(element);
            if (resourceType == null) continue;
            stubs.add(new SimpleAssociation((Object)element, (Object)resourceType));
        }
        int prev = -1;
        while (this.resourceTypes.size() != prev) {
            prev = this.resourceTypes.size();
            this.buildBaseTypes(stubs.iterator());
        }
        for (SimpleAssociation assoc : stubs) {
            IConfigurationElement resourceTypeElement = (IConfigurationElement)assoc.getKey();
            IConfigurationElement[] iConfigurationElementArray = resourceTypeElement.getChildren(BASE_TYPE_ELEMENT);
            int n5 = iConfigurationElementArray.length;
            n = 0;
            while (n < n5) {
                IConfigurationElement baseTypeElement = iConfigurationElementArray[n];
                String baseTypeID = baseTypeElement.getAttribute(ID_ATTRIBUTE);
                InternalJptResourceType baseType = this.getResourceType(baseTypeID);
                if (baseType == null) {
                    this.logInvalidBaseType((InternalJptResourceType)assoc.getValue(), baseTypeElement, baseTypeID);
                }
                ++n;
            }
        }
    }

    private InternalJptResourceType buildResourceType(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringTools.isBlank((String)id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.containsResourceType(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String contentTypeID = element.getAttribute(CONTENT_TYPE_ATTRIBUTE);
        if (contentTypeID == null) {
            this.logMissingAttribute(element, CONTENT_TYPE_ATTRIBUTE);
            return null;
        }
        IContentType contentType = this.getContentType(contentTypeID);
        if (contentType == null) {
            this.logInvalidContentType(element, id, contentTypeID);
            return null;
        }
        String version = element.getAttribute(VERSION_ATTRIBUTE);
        if (version == null) {
            version = "<undetermined>";
        }
        if (this.containsResourceType(contentType, version)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        InternalJptResourceType resourceType = new InternalJptResourceType(this, id, contentType, version);
        resourceType.setPluginId(contributor);
        return resourceType;
    }

    private IContentType getContentType(String contentTypeID) {
        return Platform.getContentTypeManager().getContentType(contentTypeID);
    }

    private void buildBaseTypes(Iterator<SimpleAssociation<IConfigurationElement, InternalJptResourceType>> stubStream) {
        while (stubStream.hasNext()) {
            SimpleAssociation<IConfigurationElement, InternalJptResourceType> next = stubStream.next();
            IConfigurationElement resourceTypeElement = (IConfigurationElement)next.getKey();
            InternalJptResourceType resourceType = (InternalJptResourceType)next.getValue();
            IConfigurationElement[] baseTypeElements = resourceTypeElement.getChildren(BASE_TYPE_ELEMENT);
            boolean validBaseTypes = true;
            HashSet<InternalJptResourceType> baseTypes = new HashSet<InternalJptResourceType>(baseTypeElements.length);
            IConfigurationElement[] iConfigurationElementArray = baseTypeElements;
            int n = baseTypeElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement baseTypeElement = iConfigurationElementArray[n2];
                String baseTypeID = baseTypeElement.getAttribute(ID_ATTRIBUTE);
                if (baseTypeID == null) {
                    this.logMissingAttribute(baseTypeElement, ID_ATTRIBUTE);
                    stubStream.remove();
                    validBaseTypes = false;
                    break;
                }
                InternalJptResourceType baseType = this.getResourceType(baseTypeID);
                if (baseType == null) {
                    validBaseTypes = false;
                    break;
                }
                baseTypes.add(baseType);
                ++n2;
            }
            if (!validBaseTypes) continue;
            resourceType.setBaseTypes(baseTypes);
            stubStream.remove();
            this.resourceTypes.add(resourceType);
        }
    }

    @Override
    public Iterable<JptResourceType> getResourceTypes() {
        return new SuperIterableWrapper(this.resourceTypes);
    }

    @Override
    public Iterable<JptResourceType> getResourceTypes(IContentType contentType) {
        return IterableTools.filter(this.getResourceTypes(), (Predicate)new ContentTypeReference.ContentTypeIs(contentType));
    }

    private boolean containsResourceType(String id) {
        return this.getResourceType(id) != null;
    }

    private InternalJptResourceType getResourceType(String id) {
        for (InternalJptResourceType resourceType : this.resourceTypes) {
            if (!resourceType.getId().equals(id)) continue;
            return resourceType;
        }
        return null;
    }

    @Override
    public JptResourceType getResourceType(IContentType contentType) {
        return this.getResourceType(contentType, "<undetermined>");
    }

    private boolean containsResourceType(IContentType contentType, String version) {
        return this.getResourceType(contentType, version) != null;
    }

    @Override
    public JptResourceType getResourceType(IContentType contentType, String version) {
        for (JptResourceType jptResourceType : this.resourceTypes) {
            if (!jptResourceType.getContentType().equals(contentType) || !jptResourceType.getVersion().equals(version)) continue;
            return jptResourceType;
        }
        return null;
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage(element, attributeName));
    }

    private void logInvalidContentType(IConfigurationElement element, String resourceTypeID, String contentTypeID) {
        this.getPlugin().logError(JptCommonCoreMessages.RESOURCE_TYPE_INVALID_CONTENT_TYPE, contentTypeID, resourceTypeID, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    private void logInvalidBaseType(InternalJptResourceType resourceType, IConfigurationElement element, String baseTypeID) {
        this.getPlugin().logError(JptCommonCoreMessages.RESOURCE_TYPE_INVALID_BASE_TYPE, baseTypeID, resourceType.getId(), element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    @Override
    public InternalJptWorkspace getJptWorkspace() {
        return this.jptWorkspace;
    }

    private String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptCommonCorePlugin getPlugin() {
        return JptCommonCorePlugin.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.resourceTypes);
    }
}

