/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.xsd;

import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.extensions.INodeAssociationProvider;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDNodeAssociationProvider
implements INodeAssociationProvider {
    @Override
    public Object getModelObject(Object parentModelObject, Element[] elementChain, int start, int[] end) {
        XSDSchema result = null;
        if (parentModelObject instanceof XSDSchemaExtensibilityElement) {
            XSDSchemaExtensibilityElement extensibilityElement = (XSDSchemaExtensibilityElement)parentModelObject;
            XSDSchema schema = extensibilityElement.getSchema();
            if (schema != null) {
                Element targetElement = elementChain[elementChain.length - 1];
                result = schema.getCorrespondingComponent((Node)targetElement);
            }
        } else if (parentModelObject instanceof CategoryAdapter) {
            result = ((CategoryAdapter)parentModelObject).getXSDSchema();
        }
        return result;
    }

    @Override
    public Node getNode(Object modelObject) {
        Element node = null;
        if (modelObject instanceof XSDSchemaExtensibilityElement) {
            XSDSchemaExtensibilityElement extensibilityElement = (XSDSchemaExtensibilityElement)modelObject;
            XSDSchema schema = extensibilityElement.getSchema();
            if (schema != null) {
                node = schema.getElement();
            }
        } else if (modelObject instanceof XSDConcreteComponent) {
            node = ((XSDConcreteComponent)modelObject).getElement();
        } else if (modelObject instanceof CategoryAdapter) {
            node = ((CategoryAdapter)modelObject).getXSDSchema().getElement();
        }
        return node;
    }
}

