/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletTagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.registry.LibraryOperation;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;

class LibraryOperationFactory {
    private final FaceletTagRegistry _tagRegistry;

    public LibraryOperationFactory(FaceletTagRegistry tagRegistry) {
        this._tagRegistry = tagRegistry;
    }

    LibraryOperation createAddOperation(IFaceletTagRecord changeRecord) {
        return new AddTagLibrary(this._tagRegistry, changeRecord);
    }

    LibraryOperation createRemoveOperation(IFaceletTagRecord changeRecord) {
        return new RemoveTagLibrary(this._tagRegistry, changeRecord);
    }

    LibraryOperation createChangeOperation(IFaceletTagRecord changeRecord) {
        if (changeRecord == null) {
            throw new IllegalArgumentException();
        }
        return new ChangeTagLibrary(this._tagRegistry, changeRecord);
    }

    private static class AddTagLibrary
    extends LibraryOperation {
        private final FaceletTagRegistry _tagRegistry;

        public AddTagLibrary(FaceletTagRegistry tagRegistry, IFaceletTagRecord newRecord) {
            super(newRecord);
            this._tagRegistry = tagRegistry;
        }

        @Override
        protected IStatus doRun() {
            this._tagRegistry.initialize(this._changeRecord, true);
            return Status.OK_STATUS;
        }
    }

    private static class ChangeTagLibrary
    extends LibraryOperation {
        private final FaceletTagRegistry _tagRegistry;

        protected ChangeTagLibrary(FaceletTagRegistry tagRegistry, IFaceletTagRecord changeRecord) {
            super(changeRecord);
            this._tagRegistry = tagRegistry;
        }

        @Override
        protected IStatus doRun() {
            IStatus result = new RemoveTagLibrary(this._tagRegistry, this._changeRecord).doRun();
            if (result.getSeverity() != 4 && result.getSeverity() != 8) {
                result = new AddTagLibrary(this._tagRegistry, this._changeRecord).doRun();
            }
            return result;
        }
    }

    private static class RemoveTagLibrary
    extends LibraryOperation {
        private final FaceletTagRegistry _tagRegistry;

        protected RemoveTagLibrary(FaceletTagRegistry tagRegistry, IFaceletTagRecord changeRecord) {
            super(changeRecord);
            this._tagRegistry = tagRegistry;
        }

        @Override
        protected IStatus doRun() {
            this._tagRegistry.remove(this._changeRecord);
            return Status.OK_STATUS;
        }
    }
}

