/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.editor;

import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.CreateDiagramJob;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Test;

public class CreateDiagramTest {
    @Test
    public void testCreateDiagramWhenPersistenceUnitHasDifferentNameFromTheProject() throws InterruptedException, CoreException {
        JPACreateFactory factory = JPACreateFactory.instance();
        JpaProject jpaProject = factory.createJPAProject("JPA_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)jpaProject);
        String persistenceUnitName = String.valueOf(jpaProject.getName()) + "_unit";
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
        pu.setName(persistenceUnitName);
        Assert.assertEquals((Object)persistenceUnitName, (Object)pu.getName());
        CreateDiagramJob createDiagramRunnable = new CreateDiagramJob(pu, 10, true);
        createDiagramRunnable.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        final Semaphore s = new Semaphore(0);
        createDiagramRunnable.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                s.release();
            }
        });
        createDiagramRunnable.setUser(true);
        createDiagramRunnable.schedule();
        s.acquire();
        Diagram d = createDiagramRunnable.getDiagram();
        Assert.assertEquals((Object)jpaProject.getName(), (Object)d.getName());
    }
}

