/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document.test;

import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public class NodeImplTestCase
extends TestCase {
    NodeImpl element;
    AttrImpl attribute;
    NodeImpl destinationNode;
    Document document;
    Element elementToImport;
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String KEY2 = "key2";
    private static final String VALUE2 = "value2";
    private static final boolean DEBUG = false;

    protected void setUp() {
        DOMModelImpl model = new DOMModelImpl();
        this.document = model.getDocument();
        this.element = (NodeImpl)this.document.createElement("testelement");
        this.attribute = (AttrImpl)this.document.createAttribute("attribute");
    }

    public void testGetUserData0() {
        NodeImplTestCase.assertEquals(null, (Object)this.element.getUserData(KEY));
        NodeImplTestCase.assertEquals(null, (Object)this.element.getUserData(null));
    }

    public void testGetUserData1() {
        this.element.setUserData(KEY, (Object)VALUE, null);
        NodeImplTestCase.assertEquals((Object)VALUE, (Object)this.element.getUserData(KEY));
        NodeImplTestCase.assertEquals(null, (Object)this.attribute.getUserData(KEY));
    }

    public void testGetUserData2() {
        this.element.setUserData(KEY, (Object)VALUE, null);
        NodeImplTestCase.assertEquals((Object)VALUE, (Object)this.element.getUserData(KEY));
        this.attribute.setUserData(KEY2, (Object)VALUE2, null);
        NodeImplTestCase.assertEquals((Object)VALUE2, (Object)this.attribute.getUserData(KEY2));
    }

    public void testGetUserData3() {
        this.element.setUserData(KEY, (Object)VALUE, null);
        this.element.setUserData(KEY2, (Object)VALUE2, null);
        NodeImplTestCase.assertEquals((Object)VALUE, (Object)this.element.getUserData(KEY));
        NodeImplTestCase.assertEquals((Object)VALUE2, (Object)this.element.getUserData(KEY2));
    }

    public void testSetUserData1() {
        NodeImplTestCase.assertEquals(null, (Object)this.element.setUserData(null, (Object)VALUE, null));
    }

    public void testSetUserData2() {
        NodeImplTestCase.assertEquals(null, (Object)this.element.setUserData(KEY, null, null));
    }

    public void testSetUserData3() {
        this.element.setUserData(KEY, (Object)VALUE, null);
        this.element.setUserData(KEY, (Object)VALUE2, null);
        NodeImplTestCase.assertEquals((Object)VALUE2, (Object)this.element.getUserData(KEY));
    }

    public void testSetUserData4() {
        this.element.setUserData(KEY, (Object)VALUE, null);
        NodeImplTestCase.assertEquals((Object)VALUE, (Object)this.element.getUserData(KEY));
        this.element.setUserData(KEY, null, null);
        NodeImplTestCase.assertEquals(null, (Object)this.element.getUserData(KEY));
    }

    public void testNotifyUserDataHandler0() {
        this.attribute.setUserData(KEY, (Object)VALUE, null);
        this.destinationNode = (NodeImpl)this.attribute.cloneNode(true);
    }

    public void testNotifyUserDataHandler1() {
        this.attribute.setUserData(KEY, (Object)VALUE, new UserDataHandler(){

            @Override
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                NodeImplTestCase.assertEquals((short)1, (short)operation);
                NodeImplTestCase.assertEquals((Object)NodeImplTestCase.VALUE, (Object)data);
                NodeImplTestCase.assertEquals((String)NodeImplTestCase.KEY, (String)key);
                NodeImplTestCase.assertEquals((Object)src, (Object)NodeImplTestCase.this.attribute);
            }
        });
        this.destinationNode = (AttrImpl)this.attribute.cloneNode(true);
    }

    public void testNotifyUserDataHandler2() {
        this.elementToImport = this.document.createElement("ElementToImport");
        ((NodeImpl)this.elementToImport).setUserData(KEY, (Object)VALUE, new UserDataHandler(){

            @Override
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                if (operation == 2) {
                    NodeImplTestCase.assertEquals((Object)NodeImplTestCase.VALUE, (Object)data);
                    NodeImplTestCase.assertEquals((String)NodeImplTestCase.KEY, (String)key);
                    NodeImplTestCase.assertEquals((Object)src, (Object)NodeImplTestCase.this.elementToImport);
                    NodeImplTestCase.assertEquals((Object)dst, null);
                }
            }
        });
        this.document.importNode(this.elementToImport, true);
    }
}

