/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

public class CloneIterator<E>
implements Iterator<E> {
    private final Iterator<Object> iterator;
    private E current;
    private final Closure<? super E> removeClosure;
    private boolean removeAllowed;

    public CloneIterator(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        this(collection.toArray(), removeClosure);
    }

    protected CloneIterator(Object[] array, Closure<? super E> removeClosure) {
        if (removeClosure == null) {
            throw new NullPointerException();
        }
        this.iterator = IteratorTools.iterator(array);
        this.current = null;
        this.removeClosure = removeClosure;
        this.removeAllowed = false;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        Object next = this.iterator.next();
        this.current = next;
        this.removeAllowed = true;
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        this.removeClosure.execute(this.current);
        this.removeAllowed = false;
    }

    public String toString() {
        return ObjectTools.toString(this);
    }
}

