/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.TrinidadUtils;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelTabbedOperation
extends AbstractTrinidadTransformOperation {
    private static final int SEP_POS_BETWEEN = -1;
    private static final int SEP_POS_START = 0;
    private static final int SEP_POS_END = 1;
    private static final String STYLECLASS_TABLE_ABOVE = "af_panelTabbed_orientation-top";
    private static final String STYLECLASS_TABLE_BELOW = "af_panelTabbed_orientation-bottom";
    private static final String STYLECLASS_SEPARATOR_START = "af_panelTabbed_cell-start";
    private static final String STYLECLASS_SEPARATOR_END = "af_panelTabbed_cell-end";
    private static final String STYLECLASS_CELL = "af_panelTabbed_tab-selected";
    private static final String STYLECLASS_CELL_NOTDISCLOSED_OR_DISABLED = "af_panelTabbed_tab";

    public Element transform(Element srcElement, Element curElement) {
        Element spanElement = this.createElement("span");
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"styleClass", "class"});
        operation.transform(srcElement, spanElement);
        operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"inlineStyle", "style"});
        operation.transform(srcElement, spanElement);
        List showDetailItems = this.getChildElements(srcElement, "showDetailItem");
        if (showDetailItems.size() > 0) {
            String tabsPosition = srcElement.getAttribute("position");
            if (tabsPosition == null || !tabsPosition.equalsIgnoreCase("above") && !tabsPosition.equalsIgnoreCase("below")) {
                tabsPosition = "both";
            }
            int showDetailItemConvertPosition = 0;
            if ("above".equalsIgnoreCase(tabsPosition) || "both".equalsIgnoreCase(tabsPosition)) {
                this.appendTabs(srcElement, showDetailItems, spanElement, true);
                ++showDetailItemConvertPosition;
            }
            int currentEditorItem = this.getCurrentShowDetailItem(srcElement, showDetailItems);
            int curItem = 0;
            for (Node nodeItem : showDetailItems) {
                if (currentEditorItem == curItem && nodeItem instanceof Element) {
                    Element elemItem = (Element)nodeItem;
                    this.tagConverterContext.addChild((Node)elemItem, new ConvertPosition((Node)spanElement, showDetailItemConvertPosition));
                    break;
                }
                ++curItem;
            }
            if ("below".equalsIgnoreCase(tabsPosition) || "both".equalsIgnoreCase(tabsPosition)) {
                this.appendTabs(srcElement, showDetailItems, spanElement, false);
            }
        } else {
            this.appendAttribute(spanElement, "style", "color:silver;font-family:Arial,Helvetica,Geneva,sans-serif;font-size:8pt;");
            this.appendChildText(Messages.PanelTabbedOperation_EmptyPanelTabbedTag, spanElement);
        }
        return spanElement;
    }

    private void appendTabs(Element srcElement, List<Node> showDetailItems, Element spanElement, boolean above) {
        Element tableElement = this.appendChildElement("table", spanElement);
        String tableStyleClass = above ? STYLECLASS_TABLE_ABOVE : STYLECLASS_TABLE_BELOW;
        this.appendAttribute(tableElement, "class", tableStyleClass);
        this.appendAttribute(tableElement, "cellpadding", "0");
        this.appendAttribute(tableElement, "cellspacing", "0");
        this.appendAttribute(tableElement, "border", "0");
        this.appendAttribute(tableElement, "width", "100%");
        this.appendAttribute(tableElement, "summary", "");
        Element trElement = this.appendChildElement("tr", tableElement);
        this.appendSeparatorTD(trElement, 0);
        int currentItem = this.getCurrentShowDetailItem(srcElement, showDetailItems);
        int disclosedItem = this.calculateDisclosedShowDetailItem(showDetailItems);
        int curItem = 0;
        for (Node nodeItem : showDetailItems) {
            if (!(nodeItem instanceof Element)) continue;
            Element elemItem = (Element)nodeItem;
            this.appendShowDetailItemTD(trElement, elemItem, currentItem == curItem, disclosedItem == curItem);
            if (curItem < showDetailItems.size() - 1) {
                this.appendSeparatorTD(trElement);
            }
            ++curItem;
        }
        this.appendSeparatorTD(trElement, 1);
    }

    private void appendSeparatorTD(Element trElement, int sepPosition) {
        Element tdElement = this.appendChildElement("td", trElement);
        if (sepPosition == 0) {
            this.appendAttribute(tdElement, "class", STYLECLASS_SEPARATOR_START);
        } else if (sepPosition == 1) {
            this.appendAttribute(tdElement, "class", STYLECLASS_SEPARATOR_END);
        }
        Element bElement = this.appendChildElement("b", tdElement);
        this.appendAttribute(bElement, "style", "margin-left:0px;");
    }

    private void appendSeparatorTD(Element trElement) {
        this.appendSeparatorTD(trElement, -1);
    }

    private void appendShowDetailItemTD(Element trElement, Element showDetailItem, boolean isCurrent, boolean isDisclosed) {
        String attrShowDetailItemInlineStyle;
        String aStyle;
        boolean isDisabled = false;
        String attrShowDetailItemDisabled = showDetailItem.getAttribute("disabled");
        if (Boolean.TRUE.toString().equalsIgnoreCase(attrShowDetailItemDisabled)) {
            isDisabled = true;
        }
        Element tdElement = this.appendChildElement("td", trElement);
        this.appendAttribute(tdElement, "height", "1");
        this.appendAttribute(tdElement, "nowrap", "nowrap");
        String tdStyleClass = isDisclosed && !isDisabled ? STYLECLASS_CELL : STYLECLASS_CELL_NOTDISCLOSED_OR_DISABLED;
        this.appendAttribute(tdElement, "class", tdStyleClass);
        Element aElement = this.appendChildElement("a", tdElement);
        if (isDisabled) {
            this.appendAttribute(aElement, "name", "name");
            aStyle = "color:#999999;";
        } else {
            this.appendAttribute(aElement, "href", "#");
            aStyle = isDisclosed ? "color:#669966;text-decoration:none;" : "color:#003333;";
        }
        if (isCurrent) {
            aStyle = String.valueOf(aStyle) + "border:1px solid #99cc99;padding:2px;";
        }
        if ((attrShowDetailItemInlineStyle = showDetailItem.getAttribute("inlineStyle")) != null && attrShowDetailItemInlineStyle.length() > 0) {
            aStyle = String.valueOf(aStyle) + attrShowDetailItemInlineStyle;
        }
        if (aStyle.length() > 0) {
            this.appendAttribute(aElement, "style", aStyle);
        }
        ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation(TransformOperationFactory.OP_CopyAttributeWithRenameOperation, new String[]{"styleClass", "class"});
        operation.transform(showDetailItem, aElement);
        String attrShowDetailItemTextAndAccessKey = showDetailItem.getAttribute("textAndAccessKey");
        if (attrShowDetailItemTextAndAccessKey != null && attrShowDetailItemTextAndAccessKey.length() > 0) {
            this.appendChildText(attrShowDetailItemTextAndAccessKey, aElement);
        } else {
            String attrShowDetailItemText = showDetailItem.getAttribute("text");
            if (attrShowDetailItemText != null && attrShowDetailItemText.length() > 0) {
                this.appendChildText(attrShowDetailItemText, aElement);
            }
        }
    }

    private int getCurrentShowDetailItem(Element srcElement, List<Node> showDetailItems) {
        int disclosedItem = TrinidadUtils.getCurrentChildIndex(srcElement);
        if (disclosedItem == -1) {
            disclosedItem = this.calculateDisclosedShowDetailItem(showDetailItems);
            TrinidadUtils.setCurrentChildIndex(srcElement, disclosedItem);
        }
        return disclosedItem;
    }

    private int calculateDisclosedShowDetailItem(List<Node> showDetailItems) {
        Element elemItem;
        int disclosedItem = -1;
        int curItem = 0;
        for (Node item : showDetailItems) {
            if (item instanceof Element) {
                elemItem = (Element)item;
                String attrDisclosedVal = elemItem.getAttribute("disclosed");
                if (Boolean.TRUE.toString().equalsIgnoreCase(attrDisclosedVal)) {
                    disclosedItem = curItem;
                    break;
                }
            }
            ++curItem;
        }
        if (disclosedItem == -1) {
            curItem = 0;
            for (Node item : showDetailItems) {
                if (item instanceof Element) {
                    elemItem = (Element)item;
                    String attrDisabledVal = elemItem.getAttribute("disabled");
                    if (!Boolean.TRUE.toString().equalsIgnoreCase(attrDisabledVal)) {
                        disclosedItem = curItem;
                        break;
                    }
                }
                ++curItem;
            }
        }
        if (disclosedItem == -1) {
            disclosedItem = 0;
        }
        return disclosedItem;
    }
}

