/*******************************************************************************
 *  Copyright (c) 2013  Oracle. All rights reserved.
 *  This program and the accompanying materials are made available under the
 *  terms of the Eclipse Public License 2.0, which accompanies this distribution
 *  and is available at https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *  
 *  Contributors: 
 *  	Oracle - initial API and implementation
 *******************************************************************************/
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;

public class JaxbPackageAdapterFactory
		implements IAdapterFactory {
	
	private static final Class<?>[] ADAPTER_LIST = new Class[] { IPackageFragment.class };
	
	
	public Class<?>[] getAdapterList() {
		return ADAPTER_LIST;
	}
	
	public Object getAdapter(Object adaptableObject, @SuppressWarnings("rawtypes") Class adapterType) {
		if (adaptableObject instanceof JaxbPackage) {
			return getAdapter((JaxbPackage) adaptableObject, adapterType);
		}
		return null;
	}
	
	private Object getAdapter(JaxbPackage packageFragment, Class<?> adapterType) {
		if (adapterType == IPackageFragment.class) {
			return getPackageFragment(packageFragment);
		}
		return null;
	}
	
	private IPackageFragment getPackageFragment(JaxbPackage jaxbPackage) {
		JaxbProject jaxbProject = jaxbPackage.getJaxbProject();
		if (jaxbProject != null) {
			 Iterator<IPackageFragment> packageFragments 
			 		= JavaProjectTools.getPackageFragments(jaxbProject.getJavaProject(), jaxbPackage.getName()).iterator();
			 if (packageFragments.hasNext()) {
				 return packageFragments.next();
			 }
		}
		return null;
	}
}
