/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jst.jsf.common.internal.types.NumericTypeLiteral;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public class IntegerLiteralType
extends NumericTypeLiteral {
    public static final IntegerLiteralType ZERO = new IntegerLiteralType(0L);
    private final long _literalValue;

    public IntegerLiteralType(long literalValue) {
        super("J");
        this._literalValue = literalValue;
    }

    @Override
    protected Number getBoxedValue() {
        return this._literalValue;
    }

    @Override
    public Number coerceToNumber(Class T) throws TypeCoercionException {
        if (T == BigInteger.class) {
            return BigInteger.valueOf(this._literalValue);
        }
        if (T == BigDecimal.class) {
            return BigDecimal.valueOf(this._literalValue);
        }
        Number commonCoercion = super.coerceToNumber(T);
        if (commonCoercion == null) {
            throw new IllegalArgumentException("Not a target numeric type: " + T);
        }
        return commonCoercion;
    }
}

