/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class InnerFunctionTests
extends TestCase {
    private static final String TEST_NAME = "Test Inner Functions JavaScript Content Assist";
    private static TestProjectSetup fTestProjectSetup;

    public InnerFunctionTests() {
        super(TEST_NAME);
    }

    public InnerFunctionTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(InnerFunctionTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false);
        return fTestProjectSetup;
    }

    public void testFindInnerFunctions_EmptyLine() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTen(paramEleven, paramTwelve) - Global", "funcTenInner2 : Function - Global", "funcTenInner2(param1, param2) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerFunctions.html", 6, 0, expectedProposals);
    }

    public void testFindInnerFunctions_ExpressionStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTen(paramEleven, paramTwelve) - Global", "funcTenInner2 : Function - Global", "funcTenInner2(param1, param2) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerFunctions.html", 8, 5, expectedProposals);
    }

    public void testFindInnerFunctions_CamelCase() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTen(paramEleven, paramTwelve) - Global", "funcTenInner2 : Function - Global", "funcTenInner2(param1, param2) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerFunctions.html", 10, 2, expectedProposals);
    }

    public void testFindInnerFunctions_EmptyLine_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTenInner : Function - Global", "funcTenInner1 : Function - Global", "funcTenInner(newParam111, newParam222) : String - Global", "funcTenInner1(param1) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerFunctions.html", 6, 0, expectedProposals, true, false);
    }

    public void testFindInnerFunctions_ExpresionStarted_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTenInner : Function - Global", "funcTenInner1 : Function - Global", "funcTenInner(newParam111, newParam222) : String - Global", "funcTenInner1(param1) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "InnerFunctions.html", 8, 5, expectedProposals, true, false);
    }

    public void testFindDuplicateInnerFunctions_EmptyLine() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "InnerFunctions.html", 6, 0);
    }

    public void testFindDuplicateInnerFunctions_ExpressionStarted() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "InnerFunctions.html", 8, 5);
    }

    public void testFindDuplicateInnerFunctions_CamelCase() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "InnerFunctions.html", 10, 2);
    }
}

