/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import javax.xml.ws.BindingType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;

public class UpdateSingleMemberAnnotationTest
extends AbstractAnnotationTest {
    protected Annotation getAnnotation() {
        return null;
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.xml.ws.BindingType;\n\n");
        classContents.append("@BindingType(\"http://schemas.xmlsoap.org/wsdl/soap/http\")\n");
        classContents.append("public class Calculator {\n\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "Calculator.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public void testUpdateSingleMemberAnnotation() {
        try {
            IType type = this.source.findPrimaryType();
            UpdateSingleMemberAnnotationTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)"BindingType"));
            Annotation bindingType = AnnotationUtils.getAnnotation((IJavaElement)type, BindingType.class);
            UpdateSingleMemberAnnotationTest.assertNotNull((Object)bindingType);
            UpdateSingleMemberAnnotationTest.assertTrue((boolean)(bindingType instanceof SingleMemberAnnotation));
            SingleMemberAnnotation bindingTypeAnnotation = (SingleMemberAnnotation)bindingType;
            StringLiteral bindingTypeValue = (StringLiteral)bindingTypeAnnotation.getValue();
            UpdateSingleMemberAnnotationTest.assertTrue((boolean)bindingTypeValue.getLiteralValue().equals("http://schemas.xmlsoap.org/wsdl/soap/http"));
            AnnotationUtils.updateSingleMemberAnnotation((SingleMemberAnnotation)bindingTypeAnnotation, (ASTNode)AnnotationsCore.createStringLiteral((AST)this.ast, (String)"http://www.w3.org/2003/05/soap/bindings/HTTP/"));
            bindingTypeAnnotation = (SingleMemberAnnotation)AnnotationUtils.getAnnotation((IJavaElement)type, BindingType.class);
            bindingTypeValue = (StringLiteral)bindingTypeAnnotation.getValue();
            UpdateSingleMemberAnnotationTest.assertTrue((boolean)bindingTypeValue.getLiteralValue().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/"));
        }
        catch (CoreException ce) {
            UpdateSingleMemberAnnotationTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

