/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;

public class JEEUtils {
    public static Servlet findServlet(WebApp webApp, String servletName) {
        if (webApp == null) {
            return null;
        }
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet == null || servlet.getServletClass() == null || !servlet.getServletClass().trim().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    public static Servlet createOrUpdateServletRef(WebApp webApp, String displayName, String className, Servlet servlet) {
        if (servlet == null) {
            servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            servlet.setServletClass(className);
            servlet.setLoadOnStartup((Object)1);
            webApp.getServlets().add(servlet);
        } else {
            JEEUtils.updateServletMappings(webApp, servlet, displayName);
            servlet.setServletName(displayName);
            servlet.setLoadOnStartup((Object)1);
        }
        return servlet;
    }

    public static void updateServletMappings(WebApp webApp, Servlet servlet, String displayName) {
        ServletMapping mapping = JEEUtils.findServletMapping(webApp, servlet);
        if (mapping != null) {
            mapping.setServletName(displayName);
        }
    }

    public static ServletMapping findServletMapping(WebApp webApp, Servlet servlet) {
        for (ServletMapping mapping : webApp.getServletMappings()) {
            if (mapping.getServletName() == null || servlet.getServletName() == null || !mapping.getServletName().trim().equals(servlet.getServletName().trim())) continue;
            return mapping;
        }
        return null;
    }

    public static void setUpURLMappings(WebApp webApp, List<String> urlMappingList, Servlet servlet) {
        if (urlMappingList.size() > 0) {
            ServletMapping mapping = JEEUtils.findServletMapping(webApp, servlet);
            if (mapping == null) {
                mapping = WebFactory.eINSTANCE.createServletMapping();
                mapping.setServletName(servlet.getServletName());
                webApp.getServletMappings().add(mapping);
            }
            for (String pattern : urlMappingList) {
                if (JEEUtils.doesServletMappingPatternExist(webApp, servlet, pattern)) continue;
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(pattern);
                mapping.getUrlPatterns().add(urlPattern);
            }
        }
    }

    public static boolean doesServletMappingPatternExist(WebApp webApp, Servlet servlet, String pattern) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getServletName() == null || !servletName.equals(mapping.getServletName().trim())) continue;
                for (UrlPatternType urlPattern : mapping.getUrlPatterns()) {
                    String patternTypeValue = urlPattern.getValue();
                    if (patternTypeValue == null || !pattern.equals(patternTypeValue.trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeURLMappings(WebApp webApp, Servlet servlet) {
        List mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            servletName = servletName.trim();
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServletName() != null && mapping.getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static void removeServlet(WebApp webApp, Servlet servlet) {
        webApp.getServlets().remove(servlet);
    }

    public static void removeContextParam(WebApp webApp, String paramName) {
        for (ParamValue cp : webApp.getContextParams()) {
            if (!cp.getParamName().equals(paramName)) continue;
            webApp.getContextParams().remove(cp);
            break;
        }
    }

    public static void setupContextParam(WebApp webApp, String paramName, String paramValue) {
        ParamValue foundCP = null;
        ParamValue cp2 = null;
        boolean found = false;
        for (ParamValue cp2 : webApp.getContextParams()) {
            if (cp2 == null || cp2.getParamName() == null || !cp2.getParamName().trim().equals(paramName)) continue;
            foundCP = cp2;
            found = true;
        }
        if (!found) {
            ParamValue pv = JavaeeFactory.eINSTANCE.createParamValue();
            pv.setParamName(paramName);
            pv.setParamValue(paramValue);
            webApp.getContextParams().add(pv);
        } else {
            cp2 = foundCP;
            if (cp2.getParamValue().indexOf(paramValue) < 0) {
                String curVal = cp2.getParamValue();
                String val = paramValue;
                if (curVal != null && !"".equals(curVal.trim())) {
                    val = String.valueOf(curVal) + ",\n" + val;
                }
                cp2.setParamValue(val);
            }
        }
    }

    public static String getContextParam(WebApp webApp, String paramName) {
        for (ParamValue cp : webApp.getContextParams()) {
            if (cp == null || cp.getParamName() == null || !cp.getParamName().trim().equals(paramName)) continue;
            return cp.getParamValue();
        }
        return null;
    }

    public static String getFileExtensionFromMap(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String ext;
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            if (extPath == null || (ext = extPath.getFileExtension()) == null || ext.equals("")) continue;
            return ext;
        }
        return null;
    }

    public static String getPrefixMapping(ServletMapping map) {
        List urls = map.getUrlPatterns();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String ext;
            Path extPath = new Path(((UrlPatternType)it.next()).getValue());
            if (extPath == null || (ext = extPath.getFileExtension()) != null) continue;
            String lastSeg = extPath.lastSegment();
            if (lastSeg.equals("*")) {
                return extPath.removeLastSegments(1).toString();
            }
            return extPath.toString();
        }
        return null;
    }
}

