/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class EditableDialogCellEditor
extends DialogCellEditor {
    private Text text;

    public EditableDialogCellEditor() {
    }

    public EditableDialogCellEditor(Composite parent) {
        super(parent);
    }

    public EditableDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 16384);
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                EditableDialogCellEditor.this.keyReleaseOccured(e);
                if (EditableDialogCellEditor.this.getControl() == null || EditableDialogCellEditor.this.getControl().isDisposed()) {
                    return;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean newValidState = EditableDialogCellEditor.this.isCorrect(EditableDialogCellEditor.this.text.getText());
                if (newValidState) {
                    EditableDialogCellEditor.this.markDirty();
                    EditableDialogCellEditor.this.doSetValue(EditableDialogCellEditor.this.text.getText());
                } else {
                    EditableDialogCellEditor.this.setErrorMessage(MessageFormat.format(EditableDialogCellEditor.this.getErrorMessage(), EditableDialogCellEditor.this.text.getText().toString()));
                }
            }
        });
        return this.text;
    }

    protected void doSetFocus() {
        this.text.setFocus();
        this.text.selectAll();
    }

    protected void updateContents(Object value) {
        if (this.text == null) {
            return;
        }
        String text_ = "";
        if (value != null) {
            text_ = value.toString();
        }
        this.text.setText(text_);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            boolean newValidState = this.isCorrect(this.text.getText());
            if (newValidState) {
                this.markDirty();
                this.doSetValue(this.text.getText());
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.text.getText().toString()));
            }
            this.fireApplyEditorValue();
        }
        super.keyReleaseOccured(keyEvent);
    }

    public Text getDefaultText() {
        return this.text;
    }
}

