/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMPosition
implements IDOMPosition {
    Node _containerNode;
    int _offset;

    public DOMPosition(Node containerNode, int offset) {
        this._containerNode = containerNode;
        this._offset = offset;
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    @Override
    public Node getNextSiblingNode() {
        if (this.isText()) {
            return null;
        }
        NodeList children = this._containerNode.getChildNodes();
        int length = children.getLength();
        if (this._offset >= length || this._offset < 0) {
            return null;
        }
        return children.item(this._offset);
    }

    @Override
    public Node getPreviousSiblingNode() {
        if (this.isText()) {
            return null;
        }
        NodeList children = this._containerNode.getChildNodes();
        int length = children.getLength();
        if (this._offset > length || this._offset <= 0) {
            return null;
        }
        return children.item(this._offset - 1);
    }

    @Override
    public Node getContainerNode() {
        return this._containerNode;
    }

    @Override
    public boolean isText() {
        return this._containerNode instanceof Text;
    }

    @Override
    public Node getSibling(boolean forward) {
        if (forward) {
            return this.getNextSiblingNode();
        }
        return this.getPreviousSiblingNode();
    }

    @Override
    public IDOMPosition handleReplacement(Node original, Node replacement) {
        if (original == this._containerNode) {
            return new DOMPosition(replacement, this._offset);
        }
        return this;
    }

    public String toString() {
        return "DOMPosition: (" + this._containerNode + " : " + this._offset + ")";
    }
}

