/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.ui.CodeStyleConfiguration;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor;

public class AdvancedQuickAssistProcessor
implements IQuickAssistProcessor {
    @Override
    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            return AdvancedQuickAssistProcessor.getInverseIfProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getIfReturnIntoIfElseAtEndOfVoidMethodProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseIfContinueIntoIfThenInLoopsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseIfIntoContinueInLoopsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseConditionProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getRemoveExtraParenthesisProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getAddParanoidalParenthesisProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getJoinAndIfStatementsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getSplitAndConditionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getJoinOrIfStatementsProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getSplitOrConditionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseConditionalExpressionProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getExchangeInnerAndOuterIfConditionsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getExchangeOperandsProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPickOutStringProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getReplaceIfElseWithConditionalProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getReplaceConditionalWithIfElseProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getInverseLocalVariableProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPushNegationDownProposals(context, coveringNode, null) || AdvancedQuickAssistProcessor.getPullNegationUpProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getJoinIfListInIfElseIfProposals(context, coveringNode, coveredNodes, null) || AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, coveringNode, null);
        }
        return false;
    }

    @Override
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList coveredNodes = AdvancedQuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
            ArrayList resultingCollections = new ArrayList();
            if (AdvancedQuickAssistProcessor.noErrorsAtLocation(locations)) {
                AdvancedQuickAssistProcessor.getInverseIfProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getIfReturnIntoIfElseAtEndOfVoidMethodProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseIfContinueIntoIfThenInLoopsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseIfIntoContinueInLoopsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseConditionProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getRemoveExtraParenthesisProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getAddParanoidalParenthesisProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinAndIfStatementsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getSplitAndConditionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinOrIfStatementsProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getSplitOrConditionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseConditionalExpressionProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getExchangeInnerAndOuterIfConditionsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getExchangeOperandsProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPickOutStringProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getReplaceIfElseWithConditionalProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getReplaceConditionalWithIfElseProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getInverseLocalVariableProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPushNegationDownProposals(context, coveringNode, resultingCollections);
                AdvancedQuickAssistProcessor.getPullNegationUpProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getJoinIfListInIfElseIfProposals(context, coveringNode, coveredNodes, resultingCollections);
                AdvancedQuickAssistProcessor.getConvertSwitchToIfProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private static boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                if (locations[i].isError()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean getIfReturnIntoIfElseAtEndOfVoidMethodProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        Statement coveringStatement = ASTResolving.findParentStatement(covering);
        if (!(coveringStatement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)coveringStatement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        Statement thenStatement = ifStatement.getThenStatement();
        if (!(thenStatement instanceof Block)) {
            return false;
        }
        Block thenBlock = (Block)thenStatement;
        List thenStatements = thenBlock.statements();
        if (thenStatements.isEmpty() || !(thenStatements.get(thenStatements.size() - 1) instanceof ReturnStatement)) {
            return false;
        }
        FunctionDeclaration coveringMetod = ASTResolving.findParentMethodDeclaration(covering);
        if (coveringMetod == null) {
            return false;
        }
        Type returnType = coveringMetod.getReturnType2();
        if (!(returnType instanceof PrimitiveType) || ((PrimitiveType)returnType).getPrimitiveTypeCode() != PrimitiveType.VOID) {
            return false;
        }
        List statements = coveringMetod.getBody().statements();
        int ifIndex = statements.indexOf(ifStatement);
        if (ifIndex == -1) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = coveringStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)thenBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
        listRewriter.remove((ASTNode)thenStatements.get(thenStatements.size() - 1), null);
        Expression conditionPlaceholder = (Expression)rewrite.createMoveTarget((ASTNode)ifStatement.getExpression());
        Statement thenPlaceholder = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement());
        Block elseBlock = ast.newBlock();
        int i = ifIndex + 1;
        while (i < statements.size()) {
            Statement statement = (Statement)statements.get(i);
            elseBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
            ++i;
        }
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(conditionPlaceholder);
        newIf.setThenStatement(thenPlaceholder);
        newIf.setElseStatement((Statement)elseBlock);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_convertToIfElse_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        Statement coveringStatement = ASTResolving.findParentStatement(covering);
        if (!(coveringStatement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)coveringStatement;
        if (ifStatement.getElseStatement() == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = coveringStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Statement thenStatement = ifStatement.getThenStatement();
        Statement elseStatement = ifStatement.getElseStatement();
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, ifStatement.getExpression());
        Statement newElseStatement = (Statement)rewrite.createMoveTarget((ASTNode)thenStatement);
        Statement newThenStatement = (Statement)rewrite.createMoveTarget((ASTNode)elseStatement);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)inversedExpression, null);
        if (elseStatement instanceof IfStatement) {
            Block elseBlock = ast.newBlock();
            elseBlock.statements().add(newThenStatement);
            newThenStatement = elseBlock;
        }
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)newThenStatement, null);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIf_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfContinueIntoIfThenInLoopsProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        Statement coveringStatement = ASTResolving.findParentStatement(covering);
        if (!(coveringStatement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)coveringStatement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (!(ifStatement.getThenStatement() instanceof ContinueStatement)) {
            return false;
        }
        Block loopBlock = null;
        if (ifStatement.getParent() instanceof Block && ifStatement.getParent().getParent() instanceof ForStatement) {
            loopBlock = (Block)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && ifStatement.getParent().getParent() instanceof WhileStatement) {
            loopBlock = (Block)ifStatement.getParent();
        } else {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = coveringStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, ifStatement.getExpression());
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(inversedExpression);
        Block thenBlock = ast.newBlock();
        int ifIndex = loopBlock.statements().indexOf(ifStatement);
        int i = ifIndex + 1;
        while (i < loopBlock.statements().size()) {
            Statement statement = (Statement)loopBlock.statements().get(i);
            thenBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
            ++i;
        }
        newIf.setThenStatement((Statement)thenBlock);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIfContinue_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseIfIntoContinueInLoopsProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        ASTRewrite rewrite;
        block10: {
            IfStatement newIf;
            Block ifParentBlock;
            IfStatement ifStatement;
            block8: {
                ASTNode ifParentStructure;
                block9: {
                    Statement coveringStatement = ASTResolving.findParentStatement(covering);
                    if (!(coveringStatement instanceof IfStatement)) {
                        return false;
                    }
                    ifStatement = (IfStatement)coveringStatement;
                    if (ifStatement.getElseStatement() != null) {
                        return false;
                    }
                    ASTNode ifParent = ifStatement.getParent();
                    ifParentBlock = null;
                    ifParentStructure = ifParent;
                    if (ifParentStructure instanceof Block) {
                        ifParentBlock = (Block)ifParent;
                        ifParentStructure = ifParentStructure.getParent();
                    }
                    if (!(ifParentStructure instanceof ForStatement || ifParentStructure instanceof WhileStatement || ifParentStructure instanceof ForInStatement)) {
                        return false;
                    }
                    if (ifParentBlock != null && ifParentBlock.statements().indexOf(ifStatement) != ifParentBlock.statements().size() - 1) {
                        return false;
                    }
                    if (resultingCollections == null) {
                        return true;
                    }
                    AST ast = coveringStatement.getAST();
                    rewrite = ASTRewrite.create((AST)ast);
                    Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, ifStatement.getExpression());
                    newIf = ast.newIfStatement();
                    newIf.setExpression(inversedExpression);
                    newIf.setThenStatement((Statement)ast.newContinueStatement());
                    if (ifParentBlock != null) break block8;
                    ifParentBlock = ast.newBlock();
                    ifParentBlock.statements().add(newIf);
                    for (Statement statement : AdvancedQuickAssistProcessor.getUnwrappedStatements(ifStatement.getThenStatement())) {
                        ifParentBlock.statements().add(rewrite.createMoveTarget((ASTNode)statement));
                    }
                    if (!(ifParentStructure instanceof ForStatement)) break block9;
                    rewrite.set(ifParentStructure, (StructuralPropertyDescriptor)ForStatement.BODY_PROPERTY, (Object)ifParentBlock, null);
                    break block10;
                }
                if (!(ifParentStructure instanceof WhileStatement)) break block10;
                rewrite.set(ifParentStructure, (StructuralPropertyDescriptor)WhileStatement.BODY_PROPERTY, (Object)ifParentBlock, null);
                break block10;
            }
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)ifParentBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
            listRewriter.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
            for (Statement statement : AdvancedQuickAssistProcessor.getUnwrappedStatements(ifStatement.getThenStatement())) {
                listRewriter.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
            }
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseIfToContinue_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static ArrayList getUnwrappedStatements(Statement body) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        if (body instanceof Block) {
            for (Statement statement : ((Block)body).statements()) {
                statements.add(statement);
            }
        } else {
            statements.add(body);
        }
        return statements;
    }

    private static boolean getInverseConditionProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) {
        if (coveredNodes.isEmpty()) {
            return false;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        boolean hasChanges = false;
        for (ASTNode covered : coveredNodes) {
            Expression coveredExpression = AdvancedQuickAssistProcessor.getBooleanExpression(covered);
            if (coveredExpression == null) continue;
            Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, coveredExpression);
            rewrite.replace((ASTNode)coveredExpression, (ASTNode)inversedExpression, null);
            hasChanges = true;
        }
        if (!hasChanges) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseConditions_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getInversedBooleanExpression(ASTRewrite rewrite, Expression expression) {
        return AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression, null);
    }

    private static Expression getRenamedNameCopy(SimpleNameRenameProvider provider, ASTRewrite rewrite, Expression expression) {
        SimpleName name;
        SimpleName newName;
        if (provider != null && expression instanceof SimpleName && (newName = provider.getRenamed(name = (SimpleName)expression)) != null) {
            return newName;
        }
        return (Expression)rewrite.createCopyTarget((ASTNode)expression);
    }

    private static Expression getInversedBooleanExpression(ASTRewrite rewrite, Expression expression, SimpleNameRenameProvider provider) {
        PrefixExpression prefixExpression;
        if (!AdvancedQuickAssistProcessor.isBoolean(expression)) {
            return (Expression)rewrite.createCopyTarget((ASTNode)expression);
        }
        AST ast = rewrite.getAST();
        if (expression instanceof BooleanLiteral) {
            return ast.newBooleanLiteral(!((BooleanLiteral)expression).booleanValue());
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            InfixExpression.Operator operator = infixExpression.getOperator();
            if (operator == InfixExpression.Operator.LESS) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.GREATER) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.LESS_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.LESS_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER, provider);
            }
            if (operator == InfixExpression.Operator.GREATER_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.LESS, provider);
            }
            if (operator == InfixExpression.Operator.EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.NOT_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.NOT_EQUALS) {
                return AdvancedQuickAssistProcessor.getInversedInfixBooleanExpression(rewrite, infixExpression, InfixExpression.Operator.EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_OR, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_AND, provider);
            }
            if (operator == InfixExpression.Operator.AND) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.OR, provider);
            }
            if (operator == InfixExpression.Operator.OR) {
                return AdvancedQuickAssistProcessor.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.AND, provider);
            }
        }
        if (expression instanceof PrefixExpression && (prefixExpression = (PrefixExpression)expression).getOperator() == PrefixExpression.Operator.NOT) {
            return AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, prefixExpression.getOperand());
        }
        if (expression instanceof InstanceofExpression) {
            prefixExpression = ast.newPrefixExpression();
            prefixExpression.setOperator(PrefixExpression.Operator.NOT);
            ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
            parenthesizedExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
            prefixExpression.setOperand((Expression)parenthesizedExpression);
            return prefixExpression;
        }
        if (expression instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
            Expression innerExpression = parenthesizedExpression.getExpression();
            while (innerExpression instanceof ParenthesizedExpression) {
                innerExpression = ((ParenthesizedExpression)innerExpression).getExpression();
            }
            if (innerExpression instanceof InstanceofExpression) {
                return AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, innerExpression, provider);
            }
            parenthesizedExpression = ast.newParenthesizedExpression();
            parenthesizedExpression.setExpression(AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, innerExpression, provider));
            return parenthesizedExpression;
        }
        prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand(AdvancedQuickAssistProcessor.getRenamedNameCopy(provider, rewrite, expression));
        return prefixExpression;
    }

    private static boolean isBoolean(Expression expression) {
        return expression.resolveTypeBinding() == expression.getAST().resolveWellKnownType("boolean");
    }

    private static Expression getInversedInfixBooleanExpression(ASTRewrite rewrite, InfixExpression expression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        newExpression.setLeftOperand(AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression.getLeftOperand(), provider));
        newExpression.setRightOperand(AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression.getRightOperand(), provider));
        return newExpression;
    }

    private static Expression parenthesizeIfRequired(Expression operand, int newOperatorPrecedence) {
        if (newOperatorPrecedence < AdvancedQuickAssistProcessor.getExpressionPrecedence(operand)) {
            return AdvancedQuickAssistProcessor.getParenthesizedExpression(operand.getAST(), operand);
        }
        return operand;
    }

    private static Expression getInversedAndOrExpression(ASTRewrite rewrite, InfixExpression infixExpression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        int newOperatorPrecedence = AdvancedQuickAssistProcessor.getInfixOperatorPrecedence(newOperator);
        Expression leftOperand = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, infixExpression.getLeftOperand(), provider);
        newExpression.setLeftOperand(AdvancedQuickAssistProcessor.parenthesizeIfRequired(leftOperand, newOperatorPrecedence));
        Expression rightOperand = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, infixExpression.getRightOperand(), provider);
        newExpression.setRightOperand(AdvancedQuickAssistProcessor.parenthesizeIfRequired(rightOperand, newOperatorPrecedence));
        List extraOperands = infixExpression.extendedOperands();
        List newExtraOperands = newExpression.extendedOperands();
        int i = 0;
        while (i < extraOperands.size()) {
            Expression extraOperand = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, (Expression)extraOperands.get(i), provider);
            newExtraOperands.add(AdvancedQuickAssistProcessor.parenthesizeIfRequired(extraOperand, newOperatorPrecedence));
            ++i;
        }
        return newExpression;
    }

    private static boolean getRemoveExtraParenthesisProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) {
        ArrayList<ASTNode> nodes;
        if (context.getSelectionLength() == 0 && covering instanceof ParenthesizedExpression) {
            nodes = new ArrayList<ASTNode>();
            nodes.add(covering);
        } else {
            nodes = coveredNodes;
        }
        if (nodes.isEmpty()) {
            return false;
        }
        IFix fix = ExpressionsFix.createRemoveUnnecessaryParenthesisFix(context.getASTRoot(), nodes.toArray(new ASTNode[nodes.size()]));
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.remove_correction.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.use_parentheses_in_expressions", "true");
        options.put("cleanup.never_use_parentheses_in_expressions", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new ExpressionsCleanUp(options), 1, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static int getExpressionPrecedence(Expression expression) {
        if (expression instanceof PostfixExpression) {
            return 0;
        }
        if (expression instanceof PrefixExpression) {
            return 1;
        }
        if (expression instanceof ClassInstanceCreation) {
            return 2;
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            InfixExpression.Operator operator = infixExpression.getOperator();
            return AdvancedQuickAssistProcessor.getInfixOperatorPrecedence(operator);
        }
        if (expression instanceof InstanceofExpression) {
            return 6;
        }
        if (expression instanceof ConditionalExpression) {
            return 13;
        }
        if (expression instanceof Assignment) {
            return 14;
        }
        if (expression instanceof FunctionInvocation) {
            return 2;
        }
        return -1;
    }

    private static int getInfixOperatorPrecedence(InfixExpression.Operator operator) {
        if (operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.DIVIDE || operator == InfixExpression.Operator.REMAINDER) {
            return 3;
        }
        if (operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.MINUS) {
            return 4;
        }
        if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            return 5;
        }
        if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS) {
            return 6;
        }
        if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS || operator == InfixExpression.Operator.EQUAL_EQUAL_EQUAL || operator == InfixExpression.Operator.NOT_EQUAL_EQUAL || operator == InfixExpression.Operator.INSTANCEOF) {
            return 7;
        }
        if (operator == InfixExpression.Operator.AND) {
            return 8;
        }
        if (operator == InfixExpression.Operator.XOR) {
            return 9;
        }
        if (operator == InfixExpression.Operator.OR) {
            return 10;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
            return 11;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
            return 12;
        }
        return -1;
    }

    private static boolean getAddParanoidalParenthesisProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) throws CoreException {
        IFix fix = ExpressionsFix.createAddParanoidalParenthesisFix(context.getASTRoot(), coveredNodes.toArray(new ASTNode[coveredNodes.size()]));
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.use_parentheses_in_expressions", "true");
        options.put("cleanup.always_use_parentheses_in_expressions", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new ExpressionsCleanUp(options), 1, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static ArrayList getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList coveredNodes = new ArrayList();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            @Override
            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    private static boolean getJoinAndIfStatementsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        Image image;
        String label;
        Statement bodyPlaceholder;
        IfStatement newIf;
        InfixExpression condition;
        Expression innerCondition;
        Expression outerCondition;
        ASTRewrite rewrite;
        AST ast;
        Block block;
        InfixExpression.Operator andOperator = InfixExpression.Operator.CONDITIONAL_AND;
        boolean result = false;
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        IfStatement outerIf = null;
        if (ifStatement.getParent() instanceof IfStatement) {
            outerIf = (IfStatement)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && (block = (Block)ifStatement.getParent()).getParent() instanceof IfStatement && block.statements().size() == 1) {
            outerIf = (IfStatement)block.getParent();
        }
        if (outerIf != null && outerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = statement.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            outerCondition = AdvancedQuickAssistProcessor.getParenthesizedForAndIfNeeded(ast, rewrite, outerIf.getExpression());
            innerCondition = AdvancedQuickAssistProcessor.getParenthesizedForAndIfNeeded(ast, rewrite, ifStatement.getExpression());
            condition = ast.newInfixExpression();
            condition.setOperator(andOperator);
            condition.setLeftOperand(outerCondition);
            condition.setRightOperand(innerCondition);
            newIf = ast.newIfStatement();
            newIf.setExpression((Expression)condition);
            bodyPlaceholder = (Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement());
            newIf.setThenStatement(bodyPlaceholder);
            rewrite.replace((ASTNode)outerIf, (ASTNode)newIf, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithOuter_description;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        IfStatement innerIf = null;
        if (ifStatement.getThenStatement() instanceof IfStatement) {
            innerIf = (IfStatement)ifStatement.getThenStatement();
        } else if (ifStatement.getThenStatement() instanceof Block && (block = (Block)ifStatement.getThenStatement()).statements().size() == 1 && block.statements().get(0) instanceof IfStatement) {
            innerIf = (IfStatement)block.statements().get(0);
        }
        if (innerIf != null && innerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = statement.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            outerCondition = AdvancedQuickAssistProcessor.getParenthesizedForAndIfNeeded(ast, rewrite, ifStatement.getExpression());
            innerCondition = AdvancedQuickAssistProcessor.getParenthesizedForAndIfNeeded(ast, rewrite, innerIf.getExpression());
            condition = ast.newInfixExpression();
            condition.setOperator(andOperator);
            condition.setLeftOperand(outerCondition);
            condition.setRightOperand(innerCondition);
            newIf = ast.newIfStatement();
            newIf.setExpression((Expression)condition);
            bodyPlaceholder = (Statement)rewrite.createCopyTarget((ASTNode)innerIf.getThenStatement());
            newIf.setThenStatement(bodyPlaceholder);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithInner_description;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        return result;
    }

    private static Expression getParenthesizedForAndIfNeeded(AST ast, ASTRewrite rewrite, Expression expression) {
        InfixExpression infixExpression;
        boolean addParentheses = false;
        int nodeType = expression.getNodeType();
        addParentheses = nodeType == 27 ? (infixExpression = (InfixExpression)expression).getOperator() == InfixExpression.Operator.CONDITIONAL_OR : nodeType == 16 || nodeType == 7 || nodeType == 62;
        expression = (Expression)rewrite.createCopyTarget((ASTNode)expression);
        if (addParentheses) {
            return AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, expression);
        }
        return expression;
    }

    private static Expression getParenthesizedExpression(AST ast, Expression expression) {
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression(expression);
        return parenthesizedExpression;
    }

    private static boolean getSplitAndConditionProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        InfixExpression.Operator andOperator = InfixExpression.Operator.CONDITIONAL_AND;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != andOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == andOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, andOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)rightCondition, null);
        IfStatement outerIfStatement = ast.newIfStatement();
        outerIfStatement.setExpression(leftCondition);
        Block outerBlock = ast.newBlock();
        outerIfStatement.setThenStatement((Statement)outerBlock);
        ASTNode ifPlaceholder = rewrite.createMoveTarget((ASTNode)ifStatement);
        outerBlock.statements().add(ifPlaceholder);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)outerIfStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitAndCondition_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isSelectingOperator(ASTNode n1, ASTNode n2, int offset, int length) {
        if (offset + length <= n2.getStartPosition() && offset >= ASTNodes.getExclusiveEnd(n1)) {
            return true;
        }
        if (n1.getStartPosition() == offset && ASTNodes.getExclusiveEnd(n2) == offset + length) {
            return !(n1 instanceof InfixExpression) && !(n2 instanceof InfixExpression);
        }
        return false;
    }

    private static int isOperatorSelected(InfixExpression infixExpression, int offset, int length) {
        Expression right;
        Expression left = infixExpression.getLeftOperand();
        if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = infixExpression.getRightOperand()), offset, length)) {
            return ASTNodes.getExclusiveEnd((ASTNode)left);
        }
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            left = right;
            if (AdvancedQuickAssistProcessor.isSelectingOperator((ASTNode)left, (ASTNode)(right = (ASTNode)extended.get(i)), offset, length)) {
                return ASTNodes.getExclusiveEnd((ASTNode)left);
            }
            ++i;
        }
        return -1;
    }

    private static boolean getJoinOrIfStatementsProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (coveredNodes.size() < 2) {
            return false;
        }
        String commonThenSource = null;
        for (ASTNode node : coveredNodes) {
            if (!(node instanceof IfStatement)) {
                return false;
            }
            IfStatement ifStatement = (IfStatement)node;
            if (ifStatement.getElseStatement() != null) {
                return false;
            }
            Statement thenStatement = ifStatement.getThenStatement();
            try {
                String thenSource = context.getCompilationUnit().getBuffer().getText(thenStatement.getStartPosition(), thenStatement.getLength());
                if (commonThenSource == null) {
                    commonThenSource = thenSource;
                    continue;
                }
                if (commonThenSource.equals(thenSource)) continue;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        InfixExpression condition = null;
        boolean hasRightOperand = false;
        Statement thenStatement = null;
        for (IfStatement ifStatement : coveredNodes) {
            if (thenStatement == null) {
                thenStatement = (Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement());
            }
            Expression ifCondition = AdvancedQuickAssistProcessor.getParenthesizedForOrIfNeeded(ast, rewrite, ifStatement.getExpression());
            if (condition == null) {
                condition = ast.newInfixExpression();
                condition.setOperator(orOperator);
                condition.setLeftOperand(ifCondition);
                continue;
            }
            if (!hasRightOperand) {
                condition.setRightOperand(ifCondition);
                hasRightOperand = true;
                continue;
            }
            InfixExpression newCondition = ast.newInfixExpression();
            newCondition.setOperator(orOperator);
            newCondition.setLeftOperand((Expression)condition);
            newCondition.setRightOperand(ifCondition);
            condition = newCondition;
        }
        IfStatement newIf = ast.newIfStatement();
        newIf.setExpression(condition);
        newIf.setThenStatement(thenStatement);
        ListRewrite listRewriter = null;
        for (IfStatement ifStatement : coveredNodes) {
            if (listRewriter == null) {
                Block sourceBlock = (Block)ifStatement.getParent();
                listRewriter = rewrite.getListRewrite((ASTNode)sourceBlock, (ChildListPropertyDescriptor)ifStatement.getLocationInParent());
            }
            if (newIf != null) {
                listRewriter.replace((ASTNode)ifStatement, (ASTNode)newIf, null);
                newIf = null;
                continue;
            }
            listRewriter.remove((ASTNode)ifStatement, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_joinWithOr_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getParenthesizedForOrIfNeeded(AST ast, ASTRewrite rewrite, Expression expression) {
        boolean addParentheses = false;
        int nodeType = expression.getNodeType();
        addParentheses = nodeType == 16 || nodeType == 7 || nodeType == 62;
        expression = (Expression)rewrite.createCopyTarget((ASTNode)expression);
        if (addParentheses) {
            return AdvancedQuickAssistProcessor.getParenthesizedExpression(ast, expression);
        }
        return expression;
    }

    private static boolean getSplitOrConditionProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != orOperator) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == orOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, orOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        IfStatement firstIf = ast.newIfStatement();
        firstIf.setExpression(leftCondition);
        firstIf.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement()));
        IfStatement secondIf = ast.newIfStatement();
        secondIf.setExpression(rightCondition);
        secondIf.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement()));
        Block sourceBlock = (Block)ifStatement.getParent();
        int insertIndex = sourceBlock.statements().indexOf(ifStatement);
        ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)sourceBlock, (ChildListPropertyDescriptor)statement.getLocationInParent());
        listRewriter.replace((ASTNode)ifStatement, (ASTNode)firstIf, null);
        listRewriter.insertAt((ASTNode)secondIf, insertIndex + 1, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitOrCondition_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseConditionalExpressionProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        while (covering instanceof Expression) {
            if (covering instanceof ConditionalExpression) break;
            covering = covering.getParent();
        }
        if (!(covering instanceof ConditionalExpression)) {
            return false;
        }
        ConditionalExpression expression = (ConditionalExpression)covering;
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ConditionalExpression newExpression = ast.newConditionalExpression();
        newExpression.setExpression(AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression.getExpression()));
        newExpression.setThenExpression((Expression)rewrite.createCopyTarget((ASTNode)expression.getElseExpression()));
        newExpression.setElseExpression((Expression)rewrite.createCopyTarget((ASTNode)expression.getThenExpression()));
        rewrite.replace((ASTNode)expression, (ASTNode)newExpression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseConditionalExpression_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getExchangeInnerAndOuterIfConditionsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTRewriteCorrectionProposal proposal;
        Image image;
        String label;
        ASTRewrite rewrite;
        AST ast;
        Block block;
        boolean result = false;
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        IfStatement outerIf = null;
        if (ifStatement.getParent() instanceof IfStatement) {
            outerIf = (IfStatement)ifStatement.getParent();
        } else if (ifStatement.getParent() instanceof Block && (block = (Block)ifStatement.getParent()).getParent() instanceof IfStatement && block.statements().size() == 1) {
            outerIf = (IfStatement)block.getParent();
        }
        if (outerIf != null && outerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = statement.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            Expression outerCondition = (Expression)rewrite.createCopyTarget((ASTNode)outerIf.getExpression());
            Expression innerCondition = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
            rewrite.replace((ASTNode)outerIf.getExpression(), (ASTNode)innerCondition, null);
            rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)outerCondition, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeInnerAndOuterIfConditions_description;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        IfStatement innerIf = null;
        if (ifStatement.getThenStatement() instanceof IfStatement) {
            innerIf = (IfStatement)ifStatement.getThenStatement();
        } else if (ifStatement.getThenStatement() instanceof Block && (block = (Block)ifStatement.getThenStatement()).statements().size() == 1 && block.statements().get(0) instanceof IfStatement) {
            innerIf = (IfStatement)block.statements().get(0);
        }
        if (innerIf != null && innerIf.getElseStatement() == null) {
            if (resultingCollections == null) {
                return true;
            }
            ast = statement.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            Expression innerCondition = (Expression)rewrite.createCopyTarget((ASTNode)innerIf.getExpression());
            Expression outerCondition = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
            rewrite.replace((ASTNode)innerIf.getExpression(), (ASTNode)outerCondition, null);
            rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)innerCondition, null);
            label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeInnerAndOuterIfConditions_description;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
            resultingCollections.add(proposal);
            result = true;
        }
        return result;
    }

    private static boolean getExchangeOperandsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        InfixExpression.Operator operator = infixExpression.getOperator();
        if (operator != InfixExpression.Operator.CONDITIONAL_AND && operator != InfixExpression.Operator.AND && operator != InfixExpression.Operator.CONDITIONAL_OR && operator != InfixExpression.Operator.OR && operator != InfixExpression.Operator.EQUALS && operator != InfixExpression.Operator.PLUS && operator != InfixExpression.Operator.TIMES && operator != InfixExpression.Operator.XOR) {
            return false;
        }
        int offset = AdvancedQuickAssistProcessor.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = infixExpression.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression leftExpression = null;
        Expression rightExpression = null;
        InfixExpression currentExpression = infixExpression;
        leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, infixExpression.getLeftOperand(), true, operator);
        if (infixExpression.getRightOperand().getStartPosition() <= context.getSelectionOffset()) {
            leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, infixExpression.getRightOperand(), true, operator);
        } else {
            rightExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, rightExpression, infixExpression.getRightOperand(), true, operator);
        }
        for (Expression extendedOperand : currentExpression.extendedOperands()) {
            if (extendedOperand.getStartPosition() <= context.getSelectionOffset()) {
                leftExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, leftExpression, extendedOperand, true, operator);
                continue;
            }
            rightExpression = AdvancedQuickAssistProcessor.combineOperands(rewrite, rightExpression, extendedOperand, true, operator);
        }
        InfixExpression newInfix = ast.newInfixExpression();
        newInfix.setOperator(operator);
        newInfix.setLeftOperand(rightExpression);
        newInfix.setRightOperand(leftExpression);
        rewrite.replace((ASTNode)infixExpression, (ASTNode)newInfix, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_exchangeOperands_description;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static void breakInfixOperationAtOperation(ASTRewrite rewrite, Expression expression, InfixExpression.Operator operator, int operatorOffset, boolean removeParenthesis, Expression[] res) {
        if (expression.getStartPosition() + expression.getLength() <= operatorOffset) {
            res[0] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[0], expression, removeParenthesis, operator);
            return;
        }
        if (operatorOffset <= expression.getStartPosition()) {
            res[1] = AdvancedQuickAssistProcessor.combineOperands(rewrite, res[1], expression, removeParenthesis, operator);
            return;
        }
        if (!(expression instanceof InfixExpression)) {
            throw new IllegalArgumentException("Cannot break up non-infix expression");
        }
        InfixExpression infixExpression = (InfixExpression)expression;
        if (infixExpression.getOperator() != operator) {
            throw new IllegalArgumentException("Incompatible operator");
        }
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getLeftOperand(), operator, operatorOffset, removeParenthesis, res);
        AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, infixExpression.getRightOperand(), operator, operatorOffset, removeParenthesis, res);
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            AdvancedQuickAssistProcessor.breakInfixOperationAtOperation(rewrite, (Expression)extended.get(i), operator, operatorOffset, removeParenthesis, res);
            ++i;
        }
    }

    private static Expression combineOperands(ASTRewrite rewrite, Expression existing, Expression nodeToAdd, boolean removeParenthesis, InfixExpression.Operator operator) {
        if (existing == null && removeParenthesis) {
            while (nodeToAdd instanceof ParenthesizedExpression) {
                nodeToAdd = ((ParenthesizedExpression)nodeToAdd).getExpression();
            }
        }
        Expression newRight = (Expression)rewrite.createMoveTarget((ASTNode)nodeToAdd);
        if (existing == null) {
            return newRight;
        }
        AST ast = rewrite.getAST();
        InfixExpression infix = ast.newInfixExpression();
        infix.setOperator(operator);
        infix.setLeftOperand(existing);
        infix.setRightOperand(newRight);
        return infix;
    }

    private static boolean getPickOutStringProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof StringLiteral)) {
            return false;
        }
        int selectionPos = context.getSelectionOffset();
        int selectionLen = context.getSelectionLength();
        if (selectionLen == 0) {
            return false;
        }
        int valueStart = node.getStartPosition() + 1;
        int valueEnd = node.getStartPosition() + node.getLength() - 1;
        if (selectionPos < valueStart || selectionPos + selectionLen > valueEnd || valueEnd - valueStart == selectionLen) {
            return false;
        }
        StringLiteral stringLiteral = (StringLiteral)node;
        String stringValue = stringLiteral.getEscapedValue();
        int firstPos = selectionPos - node.getStartPosition();
        int secondPos = firstPos + selectionLen;
        AST ast = node.getAST();
        StringLiteral leftLiteral = ast.newStringLiteral();
        StringLiteral centerLiteral = ast.newStringLiteral();
        StringLiteral rightLiteral = ast.newStringLiteral();
        try {
            leftLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(1, firstPos) + '\"');
            centerLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(firstPos, secondPos) + '\"');
            rightLiteral.setEscapedValue(String.valueOf('\"') + stringValue.substring(secondPos, stringValue.length() - 1) + '\"');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        InfixExpression expression = ast.newInfixExpression();
        expression.setOperator(InfixExpression.Operator.PLUS);
        if (firstPos != 1) {
            expression.setLeftOperand((Expression)leftLiteral);
        }
        if (firstPos == 1) {
            expression.setLeftOperand((Expression)centerLiteral);
        } else {
            expression.setRightOperand((Expression)centerLiteral);
        }
        if (secondPos < stringValue.length() - 1) {
            if (firstPos == 1) {
                expression.setRightOperand((Expression)rightLiteral);
            } else {
                expression.extendedOperands().add(rightLiteral);
            }
        }
        rewrite.replace((ASTNode)stringLiteral, (ASTNode)expression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pickSelectedString;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)centerLiteral), true, "CENTER_STRING");
        resultingCollections.add(proposal);
        return true;
    }

    private static Statement getSingleStatement(Statement statement) {
        if (statement instanceof Block) {
            List blockStatements = ((Block)statement).statements();
            if (blockStatements.size() != 1) {
                return null;
            }
            return (Statement)blockStatements.get(0);
        }
        return statement;
    }

    private static boolean getReplaceIfElseWithConditionalProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        Statement thenStatement = AdvancedQuickAssistProcessor.getSingleStatement(ifStatement.getThenStatement());
        Statement elseStatement = AdvancedQuickAssistProcessor.getSingleStatement(ifStatement.getElseStatement());
        if (thenStatement == null || elseStatement == null) {
            return false;
        }
        Expression assigned = null;
        Expression thenExpression = null;
        Expression elseExpression = null;
        ITypeBinding exprBinding = null;
        if (thenStatement instanceof ReturnStatement && elseStatement instanceof ReturnStatement) {
            thenExpression = ((ReturnStatement)thenStatement).getExpression();
            elseExpression = ((ReturnStatement)elseStatement).getExpression();
            FunctionDeclaration declaration = ASTResolving.findParentMethodDeclaration(node);
            if (declaration == null || declaration.isConstructor()) {
                return false;
            }
            if (declaration.getReturnType2() != null) {
                exprBinding = declaration.getReturnType2().resolveBinding();
            }
        } else if (thenStatement instanceof ExpressionStatement && elseStatement instanceof ExpressionStatement) {
            Expression inner1 = ((ExpressionStatement)thenStatement).getExpression();
            Expression inner2 = ((ExpressionStatement)elseStatement).getExpression();
            if (inner1 instanceof Assignment && inner2 instanceof Assignment) {
                IBinding bind2;
                IBinding bind1;
                Assignment assign1 = (Assignment)inner1;
                Assignment assign2 = (Assignment)inner2;
                Expression left1 = assign1.getLeftHandSide();
                Expression left2 = assign2.getLeftHandSide();
                if (left1 instanceof Name && left2 instanceof Name && assign1.getOperator() == assign2.getOperator() && (bind1 = ((Name)left1).resolveBinding()) == (bind2 = ((Name)left2).resolveBinding()) && bind1 instanceof IVariableBinding) {
                    assigned = left1;
                    exprBinding = ((IVariableBinding)bind1).getType();
                    thenExpression = assign1.getRightHandSide();
                    elseExpression = assign2.getRightHandSide();
                }
            }
        }
        if (thenExpression == null || elseExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_replaceIfWithConditional;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        ConditionalExpression conditionalExpression = ast.newConditionalExpression();
        Expression conditionCopy = (Expression)rewrite.createCopyTarget((ASTNode)ifStatement.getExpression());
        conditionalExpression.setExpression(conditionCopy);
        Expression thenCopy = (Expression)rewrite.createCopyTarget((ASTNode)thenExpression);
        Expression elseCopy = (Expression)rewrite.createCopyTarget((ASTNode)elseExpression);
        if (!JavaModelUtil.is50OrHigher(context.getCompilationUnit().getJavaScriptProject())) {
            ITypeBinding thenBinding = thenExpression.resolveTypeBinding();
            ITypeBinding elseBinding = elseExpression.resolveTypeBinding();
            if (thenBinding != null && elseBinding != null && exprBinding != null && !elseBinding.isAssignmentCompatible(thenBinding)) {
                proposal.createImportRewrite(context.getASTRoot());
            }
        }
        conditionalExpression.setThenExpression(thenCopy);
        conditionalExpression.setElseExpression(elseCopy);
        if (assigned == null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)conditionalExpression);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)returnStatement, null);
        } else {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)rewrite.createCopyTarget((ASTNode)assigned));
            assignment.setRightHandSide((Expression)conditionalExpression);
            assignment.setOperator(((Assignment)assigned.getParent()).getOperator());
            ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)assignment);
            rewrite.replace((ASTNode)ifStatement, (ASTNode)expressionStatement, null);
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static ReturnStatement createReturnExpression(ASTRewrite rewrite, Expression expression) {
        AST ast = rewrite.getAST();
        ReturnStatement thenReturn = ast.newReturnStatement();
        thenReturn.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
        return thenReturn;
    }

    private static Statement createAssignmentStatement(ASTRewrite rewrite, Assignment.Operator assignmentOperator, Expression origAssignee, Expression origAssigned) {
        AST ast = rewrite.getAST();
        Assignment elseAssignment = ast.newAssignment();
        elseAssignment.setOperator(assignmentOperator);
        elseAssignment.setLeftHandSide((Expression)rewrite.createCopyTarget((ASTNode)origAssignee));
        elseAssignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)origAssigned));
        ExpressionStatement statement = ast.newExpressionStatement((Expression)elseAssignment);
        return statement;
    }

    private static boolean getReplaceConditionalWithIfElseProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        ASTNode statement;
        while (!(covering instanceof ConditionalExpression) && covering instanceof Expression) {
            covering = covering.getParent();
        }
        if (!(covering instanceof ConditionalExpression)) {
            return false;
        }
        StructuralPropertyDescriptor locationInParent = covering.getLocationInParent();
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY ? covering.getParent().getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY : (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY ? !((statement = covering.getParent().getParent()) instanceof VariableDeclarationStatement) || statement.getLocationInParent() != Block.STATEMENTS_PROPERTY : locationInParent != ReturnStatement.EXPRESSION_PROPERTY)) {
            return false;
        }
        ConditionalExpression conditional = (ConditionalExpression)covering;
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression expression = conditional.getExpression();
        while (expression instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).getExpression();
        }
        IfStatement ifStatement = ast.newIfStatement();
        ifStatement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY) {
            Assignment assignment = (Assignment)covering.getParent();
            Expression assignee = assignment.getLeftHandSide();
            Assignment.Operator op = assignment.getOperator();
            ifStatement.setThenStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, assignee, conditional.getThenExpression()));
            ifStatement.setElseStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, assignee, conditional.getElseExpression()));
            rewrite.replace(covering.getParent().getParent(), (ASTNode)ifStatement, null);
        } else if (locationInParent == ReturnStatement.EXPRESSION_PROPERTY) {
            ifStatement.setThenStatement((Statement)AdvancedQuickAssistProcessor.createReturnExpression(rewrite, conditional.getThenExpression()));
            ifStatement.setElseStatement((Statement)AdvancedQuickAssistProcessor.createReturnExpression(rewrite, conditional.getElseExpression()));
            rewrite.replace(conditional.getParent(), (ASTNode)ifStatement, null);
        } else if (locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)covering.getParent();
            Assignment.Operator op = Assignment.Operator.ASSIGN;
            SimpleName assignee = frag.getName();
            ifStatement.setThenStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, (Expression)assignee, conditional.getThenExpression()));
            ifStatement.setElseStatement(AdvancedQuickAssistProcessor.createAssignmentStatement(rewrite, op, (Expression)assignee, conditional.getElseExpression()));
            rewrite.set((ASTNode)frag, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, null, null);
            ASTNode statement2 = frag.getParent();
            rewrite.getListRewrite(statement2.getParent(), Block.STATEMENTS_PROPERTY).insertAfter((ASTNode)ifStatement, statement2, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_replaceConditionalWithIf;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInverseLocalVariableProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        String newIdentifier;
        String notString;
        final AST ast = covering.getAST();
        if (!(covering instanceof SimpleName)) {
            return false;
        }
        SimpleName coveringName = (SimpleName)covering;
        if (!coveringName.isDeclaration()) {
            return false;
        }
        final IBinding variableBinding = coveringName.resolveBinding();
        if (!(variableBinding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding binding = (IVariableBinding)variableBinding;
        if (binding.isField()) {
            return false;
        }
        if (!AdvancedQuickAssistProcessor.isBoolean((Expression)coveringName)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        FunctionDeclaration method = ASTResolving.findParentMethodDeclaration(covering);
        SimpleName[] linkedNodes = LinkedNodeFinder.findByBinding((ASTNode)method, variableBinding);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseBooleanVariable;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        String oldIdentifier = coveringName.getIdentifier();
        if (oldIdentifier.startsWith(notString = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, ""))) {
            int notLength = notString.length();
            newIdentifier = oldIdentifier.length() > notLength ? String.valueOf(Character.toLowerCase(oldIdentifier.charAt(notLength))) + oldIdentifier.substring(notLength + 1) : oldIdentifier;
        } else {
            newIdentifier = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, String.valueOf(Character.toUpperCase(oldIdentifier.charAt(0))) + oldIdentifier.substring(1));
        }
        proposal.addLinkedPositionProposal("name", newIdentifier, null);
        proposal.addLinkedPositionProposal("name", oldIdentifier, null);
        final HashSet renamedNames = new HashSet();
        int i = 0;
        while (i < linkedNodes.length) {
            SimpleName name = linkedNodes[i];
            if (!renamedNames.contains(name)) {
                Expression expression;
                SimpleName newName = ast.newSimpleName(newIdentifier);
                proposal.addLinkedPosition(rewrite.track((ASTNode)newName), name == coveringName, "name");
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else if (location == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    Assignment assignment = (Assignment)name.getParent();
                    expression = assignment.getRightHandSide();
                    int exStart = expression.getStartPosition();
                    int exEnd = exStart + expression.getLength();
                    HashSet<SimpleName> overlapNames = new HashSet<SimpleName>();
                    int j = 0;
                    while (j < linkedNodes.length) {
                        int name2Start;
                        SimpleName name2 = linkedNodes[j];
                        if (name2 != null && exStart <= (name2Start = name2.getStartPosition()) && name2Start < exEnd) {
                            overlapNames.add(name2);
                        }
                        ++j;
                    }
                    SimpleNameRenameProvider provider = new SimpleNameRenameProvider(){

                        @Override
                        public SimpleName getRenamed(SimpleName simpleName) {
                            if (simpleName.resolveBinding() == variableBinding) {
                                renamedNames.add(simpleName);
                                return ast.newSimpleName(newIdentifier);
                            }
                            return null;
                        }
                    };
                    Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression, provider);
                    for (Object e : overlapNames) {
                        if (renamedNames.contains(e)) continue;
                        return false;
                    }
                    Assignment.Operator operator = assignment.getOperator();
                    if (operator == Assignment.Operator.BIT_AND_ASSIGN) {
                        Assignment assignment2 = ast.newAssignment();
                        assignment2.setLeftHandSide((Expression)newName);
                        assignment2.setRightHandSide(inversedExpression);
                        assignment2.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment2, null);
                    } else if (operator == Assignment.Operator.BIT_OR_ASSIGN) {
                        Assignment assignment3 = ast.newAssignment();
                        assignment3.setLeftHandSide((Expression)newName);
                        assignment3.setRightHandSide(inversedExpression);
                        assignment3.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment3, null);
                    } else {
                        rewrite.replace((ASTNode)expression, (ASTNode)inversedExpression, null);
                        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                    }
                } else if (location == VariableDeclarationFragment.NAME_PROPERTY) {
                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)name.getParent();
                    expression = vdf.getInitializer();
                    if (expression != null) {
                        rewrite.replace((ASTNode)expression, (ASTNode)AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression), null);
                    }
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else if (name.getParent() instanceof PrefixExpression && ((PrefixExpression)name.getParent()).getOperator() == PrefixExpression.Operator.NOT) {
                    rewrite.replace(name.getParent(), (ASTNode)newName, null);
                } else {
                    PrefixExpression expression2 = ast.newPrefixExpression();
                    expression2.setOperator(PrefixExpression.Operator.NOT);
                    expression2.setOperand((Expression)newName);
                    rewrite.replace((ASTNode)name, (ASTNode)expression2, null);
                }
            }
            ++i;
        }
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getPushNegationDownProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        PrefixExpression prefixExpression;
        PrefixExpression negationExpression = null;
        ParenthesizedExpression parenthesizedExpression = null;
        if (covering instanceof PrefixExpression && (prefixExpression = (PrefixExpression)covering).getOperator() == PrefixExpression.Operator.NOT && prefixExpression.getOperand() instanceof ParenthesizedExpression) {
            negationExpression = prefixExpression;
            parenthesizedExpression = (ParenthesizedExpression)prefixExpression.getOperand();
        }
        if (covering instanceof ParenthesizedExpression && covering.getParent() instanceof PrefixExpression && ((PrefixExpression)covering.getParent()).getOperator() == PrefixExpression.Operator.NOT) {
            negationExpression = (PrefixExpression)covering.getParent();
            parenthesizedExpression = (ParenthesizedExpression)covering;
        }
        if (negationExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, parenthesizedExpression.getExpression());
        boolean keepParentheses = false;
        if (negationExpression.getParent() instanceof Expression) {
            int inversedExpressionPrecedence;
            int parentPrecedence = AdvancedQuickAssistProcessor.getExpressionPrecedence((Expression)negationExpression.getParent());
            boolean bl = keepParentheses = parentPrecedence < (inversedExpressionPrecedence = AdvancedQuickAssistProcessor.getExpressionPrecedence(inversedExpression));
        }
        if (keepParentheses) {
            ParenthesizedExpression pe = ast.newParenthesizedExpression();
            pe.setExpression(inversedExpression);
            rewrite.replace((ASTNode)negationExpression, (ASTNode)pe, null);
        } else {
            rewrite.replace((ASTNode)negationExpression, (ASTNode)inversedExpression, null);
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pushNegationDown;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static Expression getBooleanExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return null;
        }
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == QualifiedName.NAME_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        while (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        Expression expression = (Expression)node;
        if (!AdvancedQuickAssistProcessor.isBoolean(expression)) {
            return null;
        }
        if (expression.getParent() instanceof InfixExpression) {
            return expression;
        }
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY || locationInParent == IfStatement.EXPRESSION_PROPERTY || locationInParent == WhileStatement.EXPRESSION_PROPERTY || locationInParent == DoStatement.EXPRESSION_PROPERTY || locationInParent == ReturnStatement.EXPRESSION_PROPERTY || locationInParent == ForStatement.EXPRESSION_PROPERTY || locationInParent == FunctionInvocation.ARGUMENTS_PROPERTY || locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY || locationInParent == ConditionalExpression.EXPRESSION_PROPERTY || locationInParent == PrefixExpression.OPERAND_PROPERTY) {
            return expression;
        }
        return null;
    }

    private static boolean getPullNegationUpProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) {
        if (coveredNodes.size() != 1) {
            return false;
        }
        ASTNode fullyCoveredNode = (ASTNode)coveredNodes.get(0);
        Expression expression = AdvancedQuickAssistProcessor.getBooleanExpression(fullyCoveredNode);
        if (expression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = expression.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression inversedExpression = AdvancedQuickAssistProcessor.getInversedBooleanExpression(rewrite, expression);
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression(inversedExpression);
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)parenthesizedExpression);
        rewrite.replace((ASTNode)expression, (ASTNode)prefixExpression, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_pullNegationUp;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getJoinIfListInIfElseIfProposals(IInvocationContext context, ASTNode covering, ArrayList coveredNodes, Collection resultingCollections) {
        if (coveredNodes.isEmpty()) {
            return false;
        }
        if (coveredNodes.size() < 2) {
            return false;
        }
        for (ASTNode node : coveredNodes) {
            if (!(node instanceof IfStatement)) {
                return false;
            }
            IfStatement ifStatement = (IfStatement)node;
            if (ifStatement.getElseStatement() == null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        IfStatement firstIfStatement = (IfStatement)coveredNodes.get(0);
        IfStatement firstNewIfStatement = null;
        IfStatement prevIfStatement = null;
        for (IfStatement ifStatement : coveredNodes) {
            IfStatement ifBodyStatement;
            IfStatement newIfStatement = ast.newIfStatement();
            newIfStatement.setExpression((Expression)rewrite.createMoveTarget((ASTNode)ifStatement.getExpression()));
            Statement thenStatement = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement());
            if (ifStatement.getThenStatement() instanceof IfStatement && (ifBodyStatement = (IfStatement)ifStatement.getThenStatement()).getElseStatement() == null) {
                Block thenBlock = ast.newBlock();
                thenBlock.statements().add(thenStatement);
                thenStatement = thenBlock;
            }
            newIfStatement.setThenStatement(thenStatement);
            if (prevIfStatement != null) {
                prevIfStatement.setElseStatement((Statement)newIfStatement);
                rewrite.remove((ASTNode)ifStatement, null);
            } else {
                firstNewIfStatement = newIfStatement;
            }
            prevIfStatement = newIfStatement;
        }
        rewrite.replace((ASTNode)firstIfStatement, firstNewIfStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_joinIfSequence;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertSwitchToIfProposals(IInvocationContext context, ASTNode covering, Collection resultingCollections) {
        if (!(covering instanceof SwitchStatement)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = covering.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite(context.getASTRoot(), true);
        SwitchStatement switchStatement = (SwitchStatement)covering;
        IfStatement firstIfStatement = null;
        IfStatement currentIfStatement = null;
        Block currentBlock = null;
        boolean hasStopAsLastExecutableStatement = false;
        Block defaultBlock = null;
        InfixExpression currentCondition = null;
        boolean defaultFound = false;
        ArrayList<Block> allBlocks = new ArrayList<Block>();
        for (Statement statement : switchStatement.statements()) {
            if (statement instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)statement;
                if (currentBlock != null) {
                    if (!hasStopAsLastExecutableStatement) {
                        return false;
                    }
                    currentBlock = null;
                }
                if (switchCase.isDefault()) {
                    defaultFound = true;
                    if (currentCondition == null) continue;
                    return false;
                }
                if (defaultFound) {
                    return false;
                }
                InfixExpression switchCaseCondition = AdvancedQuickAssistProcessor.createSwitchCaseCondition(ast, rewrite, importRewrite, switchStatement, switchCase);
                if (currentCondition == null) {
                    currentCondition = switchCaseCondition;
                    continue;
                }
                InfixExpression condition = ast.newInfixExpression();
                condition.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                condition.setLeftOperand((Expression)currentCondition);
                condition.setRightOperand((Expression)switchCaseCondition);
                currentCondition = condition;
                continue;
            }
            if (statement instanceof BreakStatement) {
                currentBlock = null;
                continue;
            }
            if (currentBlock == null) {
                defaultFound = false;
                if (currentCondition != null) {
                    IfStatement ifStatement;
                    if (firstIfStatement == null) {
                        ifStatement = firstIfStatement = ast.newIfStatement();
                    } else {
                        ifStatement = ast.newIfStatement();
                        currentIfStatement.setElseStatement((Statement)ifStatement);
                    }
                    currentIfStatement = ifStatement;
                    ifStatement.setExpression((Expression)currentCondition);
                    currentCondition = null;
                    currentBlock = ast.newBlock();
                    ifStatement.setThenStatement((Statement)currentBlock);
                    allBlocks.add(currentBlock);
                } else {
                    currentBlock = defaultBlock = ast.newBlock();
                    allBlocks.add(currentBlock);
                }
            }
            hasStopAsLastExecutableStatement = AdvancedQuickAssistProcessor.hasStopAsLastExecutableStatement(statement);
            Statement copyStatement = AdvancedQuickAssistProcessor.copyStatementExceptBreak(ast, rewrite, statement);
            currentBlock.statements().add(copyStatement);
        }
        if (defaultBlock != null) {
            currentIfStatement.setElseStatement(defaultBlock);
        }
        int i = 0;
        while (i < allBlocks.size()) {
            Block block = (Block)allBlocks.get(i);
            List statements = block.statements();
            if (statements.size() == 1 && statements.get(0) instanceof Block) {
                Block innerBlock = (Block)statements.remove(0);
                block.getParent().setStructuralProperty(block.getLocationInParent(), (Object)innerBlock);
            }
            ++i;
        }
        rewrite.replace((ASTNode)switchStatement, firstIfStatement, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_convertSwitchToIf;
        Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.setImportRewrite(importRewrite);
        resultingCollections.add(proposal);
        return true;
    }

    private static InfixExpression createSwitchCaseCondition(AST ast, ASTRewrite rewrite, ImportRewrite importRewrite, SwitchStatement switchStatement, SwitchCase switchCase) {
        InfixExpression condition = ast.newInfixExpression();
        condition.setOperator(InfixExpression.Operator.EQUALS);
        Expression leftExpression = (Expression)rewrite.createCopyTarget((ASTNode)switchStatement.getExpression());
        condition.setLeftOperand(leftExpression);
        Expression rightExpression = null;
        Expression expression = switchCase.getExpression();
        if (expression instanceof SimpleName && ((SimpleName)expression).resolveBinding() instanceof IVariableBinding) {
            ((SimpleName)expression).resolveBinding();
        }
        condition.setRightOperand(rightExpression);
        return condition;
    }

    private static boolean hasStopAsLastExecutableStatement(Statement lastStatement) {
        if (lastStatement instanceof ReturnStatement || lastStatement instanceof BreakStatement) {
            return true;
        }
        if (lastStatement instanceof Block) {
            Block block = (Block)lastStatement;
            lastStatement = (Statement)block.statements().get(block.statements().size() - 1);
            return AdvancedQuickAssistProcessor.hasStopAsLastExecutableStatement(lastStatement);
        }
        return false;
    }

    private static Statement copyStatementExceptBreak(AST ast, ASTRewrite rewrite, Statement source) {
        if (source instanceof Block) {
            Block block = (Block)source;
            Block newBlock = ast.newBlock();
            for (Statement statement : block.statements()) {
                if (statement instanceof BreakStatement) continue;
                newBlock.statements().add(AdvancedQuickAssistProcessor.copyStatementExceptBreak(ast, rewrite, statement));
            }
            return newBlock;
        }
        return (Statement)rewrite.createMoveTarget((ASTNode)source);
    }

    private static interface SimpleNameRenameProvider {
        public SimpleName getRenamed(SimpleName var1);
    }
}

