/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class InstallableRuntimeDecorator
implements GenericServerCompositeDecorator {
    private GenericServerRuntime fRuntime;
    private IWizardHandle fWizard;

    public InstallableRuntimeDecorator(IWizardHandle wizard, GenericServerRuntime runtime) {
        this.fRuntime = runtime;
        this.fWizard = wizard;
    }

    @Override
    public void decorate(final GenericServerComposite composite) {
        final IInstallableRuntime ir = ServerPlugin.findInstallableRuntime((String)this.fRuntime.getRuntime().getRuntimeType().getId());
        Button install = SWTUtil.createButton(composite, GenericServerUIMessages.installServerButton);
        install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(composite.getShell());
                dialog.setMessage(GenericServerUIMessages.installationDirectory);
                final String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ir.install((IPath)new Path(selectedDirectory), (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                Trace.trace((byte)2, (String)"Error installing runtime", (Throwable)e);
                            }
                        }
                    };
                    try {
                        InstallableRuntimeDecorator.this.fWizard.run(true, false, runnable);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, (String)"Error installing runtime", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public boolean validate() {
        return false;
    }
}

