/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.CopyMoveTests;
import org.eclipse.wst.jsdt.core.tests.model.TestProgressMonitor;

public class CopyMoveElementsTests
extends CopyMoveTests {
    public CopyMoveElementsTests(String name) {
        super(name);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IJavaScriptProject project = this.createJavaProject("BinaryProject", new String[]{"src"}, new String[]{"JCL_LIB"});
        this.createFile("/BinaryProject/src/X.js", "public class X {\n  int bar;\n  public void foo() {\n  }\n}");
        project.getProject().build(6, null);
        CopyMoveElementsTests.waitForAutoBuild();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P", new String[]{"src"}, new String[]{"/BinaryProject/bin"});
    }

    public static Test suite() {
        return CopyMoveElementsTests.buildModelTestSuite(CopyMoveElementsTests.class);
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("BinaryProject");
        super.tearDownSuite();
    }

    public void testCopyField() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testCopyFieldForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean foo;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, true);
    }

    public void testCopyFieldForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", false);
    }

    public void testCopyFieldRenameForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean bar;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", true);
    }

    public void testCopyFieldRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldSameParent() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeSource, null, "bar", false);
    }

    public void testCopyFieldsMultiStatus() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  Object bar;\n  char[] fred;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        IField[] fieldsSource = typeSource.getFields();
        IJavaScriptElement[] dests = new IJavaScriptElement[fieldsSource.length];
        int i = 0;
        while (i < dests.length) {
            dests[i] = typeDest;
            ++i;
        }
        dests[1] = fieldsSource[0];
        dests[2] = fieldsSource[0];
        try {
            this.startDeltas();
            boolean e = false;
            try {
                typeDest.getJavaScriptModel().copy((IJavaScriptElement[])fieldsSource, dests, null, null, false, null);
            }
            catch (JavaScriptModelException jme) {
                CopyMoveElementsTests.assertTrue((String)"Should be multistatus", (boolean)jme.getStatus().isMultiStatus());
                CopyMoveElementsTests.assertTrue((String)"Should be an invalid destination", (((IJavaScriptModelStatus)jme.getStatus().getChildren()[0]).getCode() == 978 ? 1 : 0) != 0);
                e = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Should have been an exception", (boolean)e);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo[+]: {}");
            IJavaScriptElement copy = this.generateHandle((IJavaScriptElement)fieldsSource[0], null, (IJavaScriptElement)typeDest);
            CopyMoveElementsTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
        }
        finally {
            this.stopDeltas();
        }
    }

    public void testCopyFieldsMultiStatusInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  Object bar;\n  char[] fred;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            IField[] fieldsSource = typeSource.getFields();
            IJavaScriptElement[] dests = new IJavaScriptElement[fieldsSource.length];
            int i = 0;
            while (i < dests.length) {
                dests[i] = typeDest;
                ++i;
            }
            dests[1] = fieldsSource[0];
            dests[2] = fieldsSource[0];
            this.startDeltas();
            boolean e = false;
            try {
                typeDest.getJavaScriptModel().copy((IJavaScriptElement[])fieldsSource, dests, null, null, false, null);
            }
            catch (JavaScriptModelException jme) {
                CopyMoveElementsTests.assertTrue((String)"Should be multistatus", (boolean)jme.getStatus().isMultiStatus());
                CopyMoveElementsTests.assertTrue((String)"Should be an invalid destination", (((IJavaScriptModelStatus)jme.getStatus().getChildren()[0]).getCode() == 978 ? 1 : 0) != 0);
                e = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Should have been an exception", (boolean)e);
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo[+]: {}");
            IJavaScriptElement copy = this.generateHandle((IJavaScriptElement)fieldsSource[0], null, (IJavaScriptElement)typeDest);
            CopyMoveElementsTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
        }
        finally {
            this.stopDeltas();
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldWithCollision() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean foo;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false, 977);
    }

    public void testCopyFieldWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false, 977);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        IClassFile cf = this.getClassFile("P", "/BinaryProject/bin", "", "X.class");
        this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)cf.getType(), null, null, false, 978);
    }

    public void testCopyFieldWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"/BinaryProject/bin"});
            IClassFile cf = this.getClassFile("P2", "/BinaryProject/bin", "", "X.class");
            this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)cf.getType(), null, null, false, 978);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldWithInvalidPositioning() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("invalid"), null, false, 993);
    }

    public void testCopyFieldWithInvalidPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("invalid"), null, false, 993);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyFieldWithPositioning() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean bar;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), null, false);
    }

    public void testCopyFieldWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyImport() throws CoreException {
        this.createFile("/P/src/X.js", "import java.util.*;\npublic class X {\n}");
        IImportDeclaration importSource = this.getCompilationUnit("/P/src/X.js").getImport("java.util.*");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cuDest = this.getCompilationUnit("/P/src/Y.js");
        this.copyPositive((IJavaScriptElement)importSource, (IJavaScriptElement)cuDest, null, null, false);
    }

    public void testCopyImportStatic() throws CoreException {
        this.createFile("/P/src/X.js", "import static java.lang.Math;\npublic class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
        IImportDeclaration importSource = this.getCompilationUnit("/P/src/X.js").getImport("java.lang.Math");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cuDest = this.getCompilationUnit("/P/src/Y.js");
        this.copyPositive((IJavaScriptElement)importSource, (IJavaScriptElement)cuDest, null, null, false);
        CopyMoveElementsTests.assertEquals((String)"Copied import should be static", (int)8, (int)cuDest.getImport("java.lang.Math").getFlags());
    }

    public void testCopyInitializer() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IInitializer initializerSource = typeSource.getInitializer(1);
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testCopyInitializerInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyInitializerRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IInitializer initializerSource = typeSource.getInitializer(1);
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyNegative((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, "newName", false, 983);
    }

    public void testCopyInitializerRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyNegative((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, "newName", false, 983);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyInitializerWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  int bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyInnerTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  class Inner {\n  }}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X").getType("Inner");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo() {\n  }\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            IType typeDest = cuDest.getType("Y");
            this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("foo", new String[0]), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyLocalType() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo() {\n    class Z {\n    }\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X").getFunction("foo", new String[0]).getType("Z", 1);
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cuDest = this.getCompilationUnit("/P/src/Y.js");
        this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, null, null, false);
    }

    public void testCopyMainType() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cuDest = this.getCompilationUnit("/P/src/Y.js");
        this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, null, null, false);
    }

    public void testCopyMainTypeInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethod() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testCopyMethodForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  int foo(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, true);
    }

    public void testCopyMethodForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  int foo(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", false);
    }

    public void testCopyMethodRenameForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  void bar(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", true);
    }

    public void testCopyMethodRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void bar(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodSameParent() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeSource, null, "bar", false);
    }

    public void testCopyMethodWithCollision() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false, 977);
    }

    public void testCopyMethodWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false, 977);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.copyNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)methodSource, null, null, false, 978);
    }

    public void testCopyMethodWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void bar() {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            IFunction methodDest = typeDest.getFunction("bar", new String[0]);
            this.copyNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)methodDest, null, null, false, 978);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMethodWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar() {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("bar", new String[0]), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyMoveWithInvalidRenamings() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  public void foo() {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[0]);
        this.copyNegative(new IJavaScriptElement[]{methodSource}, new IJavaScriptElement[]{typeSource}, null, new String[]{"bar", "fred"}, false, 980);
    }

    public void testCopySyntaxErrorMethod() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testCopySyntaxErrorMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.copyPositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyType() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n}\nclass Z {\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("Z");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IJavaScriptUnit cuDest = this.getCompilationUnit("/P/src/Y.js");
        this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, null, null, false);
    }

    public void testCopyTypeInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n}\nclass Z {\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("Z");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testCopyTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n}\nclass Z {\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("Z");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            this.copyPositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, (IJavaScriptElement)cuDest.getType("Y"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveConstructor() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  X(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("X", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
        CopyMoveElementsTests.assertTrue((String)"Constructor was not renamed", (boolean)typeDest.getFunction("Y", new String[]{"QString;"}).exists());
    }

    public void testMoveConstructorInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  X(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("X", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
            CopyMoveElementsTests.assertTrue((String)"Constructor was not renamed", (boolean)typeDest.getFunction("Y", new String[]{"QString;"}).exists());
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveField() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testMoveFieldForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean foo;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, true);
    }

    public void testMoveFieldForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "fred", false);
    }

    public void testMoveFieldRenameForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean bar;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", true);
    }

    public void testMoveFieldRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, "bar", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldRenameForceWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n  char fred;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), "fred", true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldSameParent() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeSource, null, "bar", false);
    }

    public void testMoveFieldWithCollision() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.js", "public class Y {\n  boolean foo;\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.moveNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false, 977);
    }

    public void testMoveFieldWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int bar;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.moveNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, null, null, false, 977);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IField fieldSource = typeSource.getField("foo");
        IClassFile cf = this.getClassFile("P", "/BinaryProject/bin", "", "X.class");
        this.moveNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)cf.getType(), null, null, false, 978);
    }

    public void testMoveFieldWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"/BinaryProject/bin"});
            IClassFile cf = this.getClassFile("P2", "/BinaryProject/bin", "", "X.class");
            this.moveNegative((IJavaScriptElement)fieldSource, (IJavaScriptElement)cf.getType(), null, null, false, 978);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveFieldWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)fieldSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveInitializer() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IInitializer initializerSource = typeSource.getInitializer(1);
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testMoveInitializerInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveInitializerRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IInitializer initializerSource = typeSource.getInitializer(1);
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.moveNegative((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, "newName", false, 983);
    }

    public void testMoveInitializerRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.moveNegative((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, null, "newName", false, 983);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveInitializerWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo;\n  {\n    foo = 10;\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IInitializer initializerSource = typeSource.getInitializer(1);
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  int bar;\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)initializerSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getField("bar"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveInnerTypeRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  class Inner {\n  }}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X").getType("Inner");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo() {\n  }\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            IType typeDest = cuDest.getType("Y");
            this.movePositive((IJavaScriptElement)typeSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("foo", new String[0]), "T", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveInnerTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  class Inner {\n  }}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X").getType("Inner");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo() {\n  }\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            IType typeDest = cuDest.getType("Y");
            this.movePositive((IJavaScriptElement)typeSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("foo", new String[0]), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMainTypes() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n}");
        IPackageFragment pkg = this.getPackage("/P/src");
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("X.js");
        IType typeSource = cu.getType("X");
        this.movePositive(new IJavaScriptElement[]{typeSource}, new IJavaScriptElement[]{cu}, null, new String[]{"Y"}, false);
        IJavaScriptUnit renamedCU = pkg.getJavaScriptUnit("Y.js");
        CopyMoveElementsTests.assertTrue((String)"Renamed element should be present", (boolean)renamedCU.getType("Y").exists());
    }

    public void testMoveMethod() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testMoveMethodForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  int foo(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, true);
    }

    public void testMoveMethodForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  int foo(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodRename() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", false);
    }

    public void testMoveMethodRenameForce() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  void bar(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", true);
    }

    public void testMoveMethodRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void bar(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", true);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, "bar", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar() {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("bar", new String[0]), "fred", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodSameParent() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeSource, null, "bar", false);
    }

    public void testMoveMethodsWithCancel() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n  void bar() {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        this.createFile("/P/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        boolean isCanceled = false;
        try {
            TestProgressMonitor monitor = TestProgressMonitor.getInstance();
            monitor.setCancelledCounter(1);
            this.movePositive((IJavaScriptElement[])typeSource.getFunctions(), new IJavaScriptElement[]{typeDest}, null, null, false, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            isCanceled = true;
        }
        CopyMoveElementsTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
    }

    public void testMoveMethodsWithCancelInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n  void bar() {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            boolean isCanceled = false;
            try {
                TestProgressMonitor monitor = TestProgressMonitor.getInstance();
                monitor.setCancelledCounter(1);
                this.movePositive((IJavaScriptElement[])typeSource.getFunctions(), new IJavaScriptElement[]{typeDest}, null, null, false, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                isCanceled = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodWithCollision() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.moveNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false, 977);
    }

    public void testMoveMethodWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void foo(String s) {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.moveNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false, 977);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.moveNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)methodSource, null, null, false, 978);
    }

    public void testMoveMethodWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  void bar() {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            IFunction methodDest = typeDest.getFunction("bar", new String[0]);
            this.moveNegative((IJavaScriptElement)methodSource, (IJavaScriptElement)methodDest, null, null, false, 978);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveMethodWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int foo(String s) {\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n  boolean bar() {\n  }\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, (IJavaScriptElement)typeDest.getFunction("bar", new String[0]), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveSyntaxErrorMethod() throws CoreException {
        this.createFile("/P/src/X.js", "public class X {\n  void foo(String s\n  }\n}");
        IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
        IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
        this.createFile("/P/src/Y.js", "public class Y {\n}");
        IType typeDest = this.getCompilationUnit("/P/src/Y.js").getType("Y");
        this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
    }

    public void testMoveSyntaxErrorMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  void foo(String s\n  }\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("X");
            IFunction methodSource = typeSource.getFunction("foo", new String[]{"QString;"});
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IType typeDest = this.getCompilationUnit("/P2/src/Y.js").getType("Y");
            this.movePositive((IJavaScriptElement)methodSource, (IJavaScriptElement)typeDest, null, null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveTypeRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n}\nclass Z {\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("Z");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            this.movePositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, (IJavaScriptElement)cuDest.getType("Y"), "T", false);
        }
        finally {
            this.deleteProject("P2");
        }
    }

    public void testMoveTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n}\nclass Z {\n}");
            IType typeSource = this.getCompilationUnit("/P/src/X.js").getType("Z");
            this.createJavaProject("P2", new String[]{"src"});
            this.createFile("/P2/src/Y.js", "public class Y {\n}");
            IJavaScriptUnit cuDest = this.getCompilationUnit("/P2/src/Y.js");
            this.movePositive((IJavaScriptElement)typeSource, (IJavaScriptElement)cuDest, (IJavaScriptElement)cuDest.getType("Y"), null, false);
        }
        finally {
            this.deleteProject("P2");
        }
    }
}

