/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxb.core.tests;

import junit.framework.TestCase;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.jaxb.core.tests.TestJavaProject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractAnnotationTest
extends TestCase {
    protected TestJavaProject testJavaProject;
    protected ICompilationUnit source;
    protected CompilationUnit compilationUnit;
    protected AST ast;
    protected ASTRewrite rewriter;
    protected Annotation annotation;
    protected TextFileChange textFileChange;

    protected void setUp() throws Exception {
        this.testJavaProject = new TestJavaProject("JavaProject");
        this.testJavaProject.setAutoBuilding(this.isAutoBuildingEnabled());
        this.testJavaProject.enableAnnotationProcessing(this.isAnnotationProcessingEnabled());
        this.source = this.testJavaProject.createCompilationUnit(this.getPackageName(), this.getClassName(), this.getClassContents());
        this.compilationUnit = this.getAST(this.source);
        this.ast = this.compilationUnit.getAST();
        this.rewriter = ASTRewrite.create((AST)this.ast);
        this.annotation = this.getAnnotation();
        this.textFileChange = new TextFileChange("Add annotation", (IFile)this.source.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        this.textFileChange.setEdit((TextEdit)multiTextEdit);
    }

    protected boolean isAutoBuildingEnabled() {
        return false;
    }

    protected boolean isAnnotationProcessingEnabled() {
        return false;
    }

    protected abstract String getPackageName();

    protected abstract String getClassName();

    protected abstract String getClassContents();

    protected abstract Annotation getAnnotation();

    protected boolean executeChange(IProgressMonitor monitor, Change change) {
        if (change == null) {
            return false;
        }
        change.initializeValidationData(monitor);
        PerformChangeOperation changeOperation = new PerformChangeOperation(change);
        try {
            changeOperation.run(monitor);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return changeOperation.changeExecuted();
    }

    protected void tearDown() throws Exception {
        this.deleteProject(this.testJavaProject.getProject());
    }

    private void deleteProject(IProject project) throws CoreException, InterruptedException {
        int noAttempts = 0;
        while (project != null && project.exists() && noAttempts < 5) {
            try {
                ++noAttempts;
                if (project.isOpen()) {
                    project.close(null);
                }
                project.delete(true, true, null);
            }
            catch (ResourceException re) {
                System.out.println(re.getLocalizedMessage());
                Thread.sleep(1L);
            }
        }
    }

    private CompilationUnit getAST(ICompilationUnit source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        return (CompilationUnit)parser.createAST(null);
    }
}

