/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class XMLUIPreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.xml.ui");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                XMLUIPreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.xml.ui");
            }
        }
        catch (BundleException e) {
            XMLUIPreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.xml.ui exception: " + (Object)((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.wst.xml.ui", XMLUIPreferenceNames.AUTO_PROPOSE);
        this.bundleGetPreference("org.eclipse.wst.xml.ui", XMLUIPreferenceNames.AUTO_PROPOSE_CODE);
        this.bundleGetPreference("org.eclipse.wst.xml.ui", XMLUIPreferenceNames.USE_INFERRED_GRAMMAR);
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String value = Platform.getPreferencesService().getString(bundleName, prefKey, defaultValue, null);
        XMLUIPreferencesTest.assertNotSame((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (Object)defaultValue, (Object)value);
    }

    public void testPluginGetDefaultPreferences() {
        IPreferenceStore store = XMLUIPlugin.getDefault().getPreferenceStore();
        this.pluginGetDefaultPreference(store, XMLUIPreferenceNames.AUTO_PROPOSE, Boolean.toString(true));
        this.pluginGetDefaultPreference(store, XMLUIPreferenceNames.AUTO_PROPOSE_CODE, "<=:");
        this.pluginGetDefaultPreference(store, XMLUIPreferenceNames.USE_INFERRED_GRAMMAR, Boolean.toString(true));
    }

    private void pluginGetDefaultPreference(IPreferenceStore store, String prefKey, String expected) {
        String defaultValue = store.getDefaultString(prefKey);
        XMLUIPreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)defaultValue);
    }

    public void testPluginSetPreferences() {
        IPreferenceStore store = XMLUIPlugin.getDefault().getPreferenceStore();
        this.pluginSetPreferenceBoolean(store, XMLUIPreferenceNames.AUTO_PROPOSE);
        this.pluginSetPreferenceString(store, XMLUIPreferenceNames.AUTO_PROPOSE_CODE);
        this.pluginSetPreferenceBoolean(store, XMLUIPreferenceNames.USE_INFERRED_GRAMMAR);
    }

    private void pluginSetPreferenceBoolean(IPreferenceStore store, String prefKey) {
        boolean originalValue = store.getBoolean(prefKey);
        boolean expectedValue = !originalValue;
        store.setValue(prefKey, expectedValue);
        boolean foundValue = store.getBoolean(prefKey);
        XMLUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        store.setValue(prefKey, originalValue);
    }

    private void pluginSetPreferenceString(IPreferenceStore store, String prefKey) {
        String originalValue = store.getString(prefKey);
        String expectedValue = Long.toString(System.currentTimeMillis());
        store.setValue(prefKey, expectedValue);
        String foundValue = store.getString(prefKey);
        XMLUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (String)expectedValue, (String)foundValue);
        store.setValue(prefKey, originalValue);
    }
}

