/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.browserfixture;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.TabDebugEventListener;
import org.eclipse.wst.jsdt.chromium.UnsupportedVersionException;
import org.eclipse.wst.jsdt.chromium.internal.BrowserFactoryImplTestGate;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.FixtureChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.standalonev8.StandaloneVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractAttachedTest<T extends Connection>
implements DebugEventListener,
TabDebugEventListener {
    protected FixtureChromeStub messageResponder;
    protected StandaloneVmImpl javascriptVm;
    protected DebugContext suspendContext;
    protected Script loadedScript;
    protected Runnable suspendCallback;
    protected Runnable closedCallback;
    protected Runnable navigatedCallback;
    protected Runnable scriptLoadedCallback;
    protected String newTabUrl;
    protected boolean isDisconnected = false;
    protected T connection;

    @Before
    public void setUpBefore() throws Exception {
        this.newTabUrl = "";
        this.messageResponder = new FixtureChromeStub();
        this.connection = this.createConnection();
        this.attachToBrowserTab();
    }

    @After
    public void tearDownAfter() {
    }

    protected void attachToBrowserTab() throws IOException, UnsupportedVersionException {
        this.javascriptVm = BrowserFactoryImplTestGate.createStandalone(new FakeConnection(this.messageResponder), FakeConnection.HANDSHAKER);
        this.javascriptVm.attach((DebugEventListener)this);
    }

    protected abstract T createConnection();

    protected T getConnection() {
        return this.connection;
    }

    @After
    public void tearDown() {
        this.suspendContext = null;
    }

    public void closed() {
        this.newTabUrl = null;
        if (this.closedCallback != null) {
            this.closedCallback.run();
        }
    }

    public void disconnected() {
        this.isDisconnected = true;
    }

    public DebugEventListener getDebugEventListener() {
        return this;
    }

    public void navigated(String newUrl) {
        this.newTabUrl = newUrl;
        if (this.navigatedCallback != null) {
            this.navigatedCallback.run();
        }
    }

    public void resumed() {
        this.suspendContext = null;
    }

    public void suspended(DebugContext context) {
        this.suspendContext = context;
        if (this.suspendCallback != null) {
            this.suspendCallback.run();
        }
    }

    public void scriptLoaded(Script newScript) {
        this.loadedScript = newScript;
        if (this.scriptLoadedCallback != null) {
            this.scriptLoadedCallback.run();
        }
    }

    public void scriptCollected(Script script) {
    }

    protected CountDownLatch expectSuspend() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.suspendCallback = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        return latch;
    }

    protected void resume() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] failure = new String[1];
        this.suspendContext.continueVm(DebugContext.StepAction.CONTINUE, 0, new DebugContext.ContinueCallback(){

            public void failure(String errorMessage) {
                failure[0] = errorMessage == null ? "" : errorMessage;
                latch.countDown();
            }

            public void success() {
                latch.countDown();
            }
        });
        latch.await();
        Assert.assertNull((String)("Failure on continue: " + failure[0]), (Object)failure[0]);
        Assert.assertNull((Object)this.suspendContext);
    }

    public DebugEventListener.VmStatusListener getVmStatusListener() {
        return null;
    }

    public void scriptContentChanged(Script newScript) {
    }
}

