/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel;

import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ArrayElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.FieldElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.MethodElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.ParameterElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.SimpleElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.jst.ws.internal.consumption.sampleapp.common.SamplePropertyDescriptor;
import org.eclipse.wst.ws.internal.datamodel.BasicElement;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class BeanModelElementsFactory {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String RETURN_PARAM_NAME = "returnp";

    private BeanModelElementsFactory() {
    }

    public static Element getBeanModelElement(Object object) {
        return BeanModelElementsFactory.getBeanModelElement(object, null, null);
    }

    public static Element getBeanModelElement(Object object, Element parentElement) {
        return BeanModelElementsFactory.getBeanModelElement(object, parentElement, null);
    }

    public static Element getBeanModelElement(Object object, Element parentElement, Model model) {
        BasicElement returnElement = null;
        if (object instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)object;
            String javaName = javaClass.getJavaName();
            if (!javaClass.isArray()) {
                if (parentElement == null && model == null) {
                    returnElement = new BeanElement(javaName);
                } else if (parentElement == null && model != null) {
                    returnElement = new BeanElement(javaName, model, false);
                } else if (parentElement instanceof ParameterElement) {
                    ParameterElement tempElement = (ParameterElement)parentElement;
                    returnElement = new BeanElement(tempElement, javaName);
                } else if (parentElement instanceof AttributeElement) {
                    AttributeElement tempElement = (AttributeElement)parentElement;
                    returnElement = new BeanElement(tempElement, javaName);
                } else if (parentElement instanceof FieldElement) {
                    FieldElement tempElement = (FieldElement)parentElement;
                    returnElement = new BeanElement(tempElement, javaName);
                } else if (parentElement instanceof MethodElement) {
                    returnElement = new ParameterElement((MethodElement)parentElement, RETURN_PARAM_NAME, "returnparameters", true);
                }
            } else if (parentElement == null && model == null) {
                returnElement = new ArrayElement(javaName);
            } else if (parentElement == null && model != null) {
                returnElement = new ArrayElement(javaName, model, false);
            } else if (parentElement instanceof ParameterElement) {
                ParameterElement tempElement = (ParameterElement)parentElement;
                returnElement = new ArrayElement(tempElement, javaName);
            } else if (parentElement instanceof AttributeElement) {
                AttributeElement tempElement = (AttributeElement)parentElement;
                returnElement = new ArrayElement(tempElement, javaName);
            } else if (parentElement instanceof FieldElement) {
                FieldElement tempElement = (FieldElement)parentElement;
                returnElement = new ArrayElement(tempElement, javaName);
            } else if (parentElement instanceof MethodElement) {
                returnElement = new ParameterElement((MethodElement)parentElement, RETURN_PARAM_NAME, "returnparameters", true);
            }
        } else if (object instanceof SamplePropertyDescriptor) {
            SamplePropertyDescriptor pd = (SamplePropertyDescriptor)object;
            returnElement = new AttributeElement((BeanElement)parentElement, pd.getName());
        } else if (object instanceof Field) {
            Field field = (Field)object;
            returnElement = new FieldElement((BeanElement)parentElement, field.getName());
        } else if (object instanceof Method) {
            Method method = (Method)object;
            returnElement = new MethodElement((BeanElement)parentElement, method.getName(), method.getMethodElementSignature());
        } else if (object instanceof String) {
            String name = (String)object;
            returnElement = new AttributeElement((BeanElement)parentElement, name);
        } else if (object instanceof JavaParameter) {
            JavaParameter javaParameter = (JavaParameter)object;
            if (javaParameter.isReturn()) {
                returnElement = new ParameterElement((MethodElement)parentElement, RETURN_PARAM_NAME, "returnparameters", true);
            } else {
                String name = javaParameter.getQualifiedName();
                int index = name.lastIndexOf(".");
                String shortName = index != -1 ? name.substring(++index) : name;
                returnElement = new ParameterElement((MethodElement)parentElement, shortName, "parameters", false);
            }
        } else if (object instanceof JavaHelpers) {
            JavaHelpers javaHelper = (JavaHelpers)object;
            String javaName = javaHelper.isArray() ? TypeFactory.ARRAY_NAME : javaHelper.getJavaName();
            if (parentElement instanceof ParameterElement) {
                returnElement = new SimpleElement((ParameterElement)parentElement, javaName, javaHelper.isPrimitive());
            } else if (parentElement instanceof AttributeElement) {
                returnElement = new SimpleElement((AttributeElement)parentElement, javaName, javaHelper.isPrimitive());
            } else if (parentElement instanceof FieldElement) {
                returnElement = new SimpleElement((FieldElement)parentElement, javaName, javaHelper.isPrimitive());
            } else if (parentElement instanceof MethodElement) {
                returnElement = new ParameterElement((MethodElement)parentElement, RETURN_PARAM_NAME, "returnparameters", true);
            }
        }
        return returnElement;
    }
}

