/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UIProjectUtilities {
    public static IProject getSelectedProject(IStructuredSelection selection) {
        return UIProjectUtilities.getSelectedProject(selection, null);
    }

    public static IProject getSelectedProject(IStructuredSelection selection, String expectedNatureId) {
        return UIProjectUtilities.getSelectedProject(selection, new String[]{expectedNatureId});
    }

    public static IProject getSelectedProject(IStructuredSelection selection, String[] possibleNatureIds) {
        IProject[] projects = UIProjectUtilities.getAllSelectedProjects(selection, possibleNatureIds);
        if (projects == null || projects.length == 0) {
            return null;
        }
        return projects[0];
    }

    public static IProject[] getAllSelectedProjects(IStructuredSelection selection) {
        return UIProjectUtilities.getAllSelectedProjects(selection, null);
    }

    public static IProject[] getAllSelectedProjects(IStructuredSelection selection, String expectedNatureId) {
        return UIProjectUtilities.getAllSelectedProjects(selection, new String[]{expectedNatureId});
    }

    public static IProject[] getAllSelectedProjects(IStructuredSelection selection, String[] possibleNatureIds) {
        if (selection != null && !selection.isEmpty()) {
            Object obj2 = null;
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (Object obj2 : selection) {
                IJavaElement javaElement;
                IProject project = null;
                if (obj2 instanceof IProject) {
                    project = obj2;
                } else if (obj2 instanceof IAdaptable && (project = (IProject)((IAdaptable)obj2).getAdapter(IProject.class)) == null && (javaElement = (IJavaElement)((IAdaptable)obj2).getAdapter(IJavaElement.class)) != null) {
                    project = javaElement.getJavaProject().getProject();
                }
                if (project == null && obj2 instanceof EObject) {
                    project = ProjectUtilities.getProject((EObject)obj2);
                } else if (project == null && obj2 instanceof ItemProvider) {
                    Object temp = ((ItemProvider)obj2).getParent(EObject.class);
                    if (temp != null && temp instanceof EObject) {
                        project = ProjectUtilities.getProject((EObject)((EObject)temp));
                    }
                } else if (project == null && obj2 instanceof IFile) {
                    project = ProjectUtilities.getProject(obj2);
                }
                if (project != null && possibleNatureIds != null && possibleNatureIds.length > 0) {
                    try {
                        int i = 0;
                        while (i < possibleNatureIds.length) {
                            if (project.hasNature(possibleNatureIds[i])) {
                                projects.add(project);
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                    continue;
                }
                projects.add(project);
            }
            IProject[] finalProjects = new IProject[projects.size()];
            projects.toArray(finalProjects);
            return finalProjects;
        }
        return new IProject[0];
    }
}

