/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocol;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCasting;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.DynamicParserImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.CommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.IncomingMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8NativeProtocolParser;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.junit.Before;
import org.junit.Test;

public class TestProtocolParser {
    private TestParser testParser;

    @Before
    public void setUpBefore() throws Exception {
        ArrayList<Class> types = new ArrayList<Class>(2);
        types.add(SimpleData.class);
        types.add(Cases.class);
        this.testParser = (TestParser)new DynamicParserImpl(TestParser.class, types).getParserRoot();
    }

    @Test
    public void test1() throws JsonProtocolParseException, ParseException {
        String sample = "{'seq':0,'request_seq':1,'type':'response','command':'version','success':true,'body':{'V8Version':'1.3.19 (candidate)'},'refs':[],'running':true}".replace('\'', '\"');
        JSONObject json = JsonUtil.jsonObjectFromJson((String)sample);
        V8NativeProtocolParser parser = V8ProtocolParserAccess.get();
        IncomingMessage response = parser.parseIncomingMessage(json);
        response.seq();
        response.type();
        CommandResponse commandResponse = response.asCommandResponse();
        commandResponse.requestSeq();
        commandResponse.success();
        SuccessCommandResponse successResponse = commandResponse.asSuccess();
        successResponse.running();
        successResponse.body();
        successResponse.refs();
        parser.parseSuccessCommandResponse(json);
        response = null;
    }

    @Test
    public void testTypeOverArray() throws JsonProtocolParseException, ParseException {
        String sample = "{'a': [1, 2, 3]}".replace('\'', '\"');
        JSONObject json = JsonUtil.jsonObjectFromJson((String)sample);
        SimpleData simpleData = this.testParser.parseSimpleData(json);
        Cases cases = simpleData.a();
        cases.asList();
    }

    @Test
    public void testTypeOverNumber() throws JsonProtocolParseException, ParseException {
        String sample = "{'a': 1}".replace('\'', '\"');
        JSONObject json = JsonUtil.jsonObjectFromJson((String)sample);
        SimpleData simpleData = this.testParser.parseSimpleData(json);
        Cases cases = simpleData.a();
        cases.asNumber();
    }

    @JsonType(subtypesChosenManually=true)
    public static interface Cases {
        @JsonSubtypeCasting
        public List<Object> asList() throws JsonProtocolParseException;

        @JsonSubtypeCasting
        public long asNumber() throws JsonProtocolParseException;
    }

    @JsonType
    public static interface SimpleData {
        public Cases a();
    }

    @JsonParserRoot
    static interface TestParser {
        @JsonParseMethod
        public SimpleData parseSimpleData(JSONObject var1) throws JsonProtocolParseException;
    }
}

