/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.application;

import org.eclipse.emf.ecore.EFactory;
/**
 * @generated
 * @since 1.0 */
public interface ApplicationFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ApplicationFactory eINSTANCE = org.eclipse.jst.j2ee.application.internal.impl.ApplicationFactoryImpl.init();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return Application value
	 */
	Application createApplication();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return Module value
	 */
	Module createModule();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return WebModule value
	 */
	WebModule createWebModule();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return JavaClientModule value
	 */
	JavaClientModule createJavaClientModule();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return EjbModule value
	 */
	EjbModule createEjbModule();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return ConnectorModule value
	 */
	ConnectorModule createConnectorModule();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * This method is NOT api, and may change in future releases.  
	 * EMF package classes should be access via their "eINSTANCE" static fields
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	ApplicationPackage getApplicationPackage();

}






