/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP1001
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1001(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("request")) {
            Vector requestLine = this.validator.getPostRequest(httpHeader);
            if (requestLine == null || requestLine.size() == 0) {
                this.result = "notApplicable";
            } else {
                String method = (String)requestLine.get(0);
                String httpVersion = (String)requestLine.get(2);
                if (method.equals("POST") && httpVersion != null) {
                    if (httpVersion.equals("HTTP/1.1")) {
                        this.result = "passed";
                    } else {
                        this.result = "warning";
                        this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
                    }
                }
            }
        } else if (httpHeader.startsWith("HTTP/1.1")) {
            this.result = "passed";
        } else {
            this.result = "warning";
            this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

