/*******************************************************************************
 * Copyright (c) 2011, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0, which accompanies this distribution
 * and is available at https://www.eclipse.org/legal/epl-2.0/.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;

public class GenericJavaGeneratorConversionWizardPage
	extends GenericJavaMetadataConversionWizardPage
{
	public GenericJavaGeneratorConversionWizardPage(JpaProject jpaProject) {
		super(jpaProject, JptJpaUiMessages.JAVA_GENERATOR_CONVERSION_WIZARD_PAGE_TITLE, JptJpaUiMessages.JAVA_GENERATOR_CONVERSION_WIZARD_PAGE_DESCRIPTION);
	}

	@Override
	protected boolean hasConvertibleJavaMetadata_() {
		return this.persistenceUnit.hasConvertibleJavaGenerators();
	}

	@Override
	protected String getMissingJavaMetadataWarningMessage() {
		return 	JptJpaUiMessages.JAVA_METADATA_CONVERSION_NO_GENERATORS_TO_CONVERT;
	}

	@Override
	protected ConversionCommand.Strategy getConversionCommandStrategy() {
		return CONVERSION_COMMAND_STRATEGY;
	}

	public static final ConversionCommandStrategy CONVERSION_COMMAND_STRATEGY = new ConversionCommandStrategy();

	protected static class ConversionCommandStrategy
		implements ConversionCommand.Strategy
	{
		public void execute(EntityMappings entityMappings, IProgressMonitor monitor) {
			entityMappings.getPersistenceUnit().convertJavaGenerators(entityMappings, monitor);
		}
	}
}
