/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.tests.SSEModelXMLTestsPlugin;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public abstract class UnzippedProjectTester
extends TestCase {
    protected static IProject fTestProject;
    private static boolean fTestProjectInitialized;
    private static int nSetups;
    private static final String TEST_PROJECT_NAME = "org.eclipse.wst.sse.core.internal.encoding.newtests";
    private static final boolean DEBUG = false;

    static {
        nSetups = 0;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            UnzippedProjectTester.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File zipFile = SSEModelXMLTestsPlugin.getTestFile("testfiles.zip");
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(zipFile, destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = UnzippedProjectTester.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        UnzippedProjectTester.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        UnzippedProjectTester.assertTrue((boolean)fTestProject.exists());
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

