/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.SystemTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class TypeDeclarationToolsTests
extends TestCase {
    public TypeDeclarationToolsTests(String name) {
        super(name);
    }

    public void testIsArrayString() throws Exception {
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"java.lang.Object[]"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"java.lang.Object[][][]"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((String)"int"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"int[]"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"int[][][]"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((String)"float"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"float [ ]"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((String)"float[] [] []"));
    }

    public void testIsArrayCharArray() throws Exception {
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((char[])"java.lang.Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"java.lang.Object[]".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"java.lang.Object[][][]".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((char[])"int".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"int[]".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"int[][][]".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isArray((char[])"float".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"float [ ]".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isArray((char[])"float[] [] []".toCharArray()));
    }

    public void testArrayDepthString() throws Exception {
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((String)"java.lang.Object[]"));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((String)"java.lang.Object[][][]"));
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((String)"int"));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((String)"int[][][]"));
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((String)"float"));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((String)"float [ ]"));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((String)"float[] [] []"));
    }

    public void testArrayDepthCharArray() throws Exception {
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((char[])"java.lang.Object".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((char[])"java.lang.Object[]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((char[])"java.lang.Object[][][]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((char[])"int".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((char[])"int[]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((char[])"int[][][]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)0, (int)TypeDeclarationTools.arrayDepth((char[])"float".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)1, (int)TypeDeclarationTools.arrayDepth((char[])"float [ ]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals((int)3, (int)TypeDeclarationTools.arrayDepth((char[])"float[] [] []".toCharArray()));
    }

    public void testElementTypeNameString() throws Exception {
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object", (String)TypeDeclarationTools.elementTypeName((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object", (String)TypeDeclarationTools.elementTypeName((String)"java.lang.Object[]"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object", (String)TypeDeclarationTools.elementTypeName((String)"java.lang.Object[][][]"));
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.elementTypeName((String)"int"));
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.elementTypeName((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.elementTypeName((String)"int[][][]"));
        TypeDeclarationToolsTests.assertEquals((String)"float", (String)TypeDeclarationTools.elementTypeName((String)"float"));
        TypeDeclarationToolsTests.assertEquals((String)"float", (String)TypeDeclarationTools.elementTypeName((String)"float [ ]"));
        TypeDeclarationToolsTests.assertEquals((String)"float", (String)TypeDeclarationTools.elementTypeName((String)"float[] [] []"));
    }

    public void testElementTypeNameCharArray() throws Exception {
        TestTools.assertEquals("java.lang.Object", TypeDeclarationTools.elementTypeName((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("java.lang.Object", TypeDeclarationTools.elementTypeName((char[])"java.lang.Object[]".toCharArray()));
        TestTools.assertEquals("java.lang.Object", TypeDeclarationTools.elementTypeName((char[])"java.lang.Object[][][]".toCharArray()));
        TestTools.assertEquals("int", TypeDeclarationTools.elementTypeName((char[])"int".toCharArray()));
        TestTools.assertEquals("int", TypeDeclarationTools.elementTypeName((char[])"int[]".toCharArray()));
        TestTools.assertEquals("int", TypeDeclarationTools.elementTypeName((char[])"int[][][]".toCharArray()));
        TestTools.assertEquals("float", TypeDeclarationTools.elementTypeName((char[])"float".toCharArray()));
        TestTools.assertEquals("float", TypeDeclarationTools.elementTypeName((char[])"float [ ]".toCharArray()));
        TestTools.assertEquals("float", TypeDeclarationTools.elementTypeName((char[])"float[] [] []".toCharArray()));
    }

    public void testComponentTypeDeclarationString() throws Exception {
        TypeDeclarationToolsTests.assertEquals(null, (String)TypeDeclarationTools.componentTypeDeclaration((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object", (String)TypeDeclarationTools.componentTypeDeclaration((String)"java.lang.Object[]"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object[][]", (String)TypeDeclarationTools.componentTypeDeclaration((String)"java.lang.Object[][][]"));
        TypeDeclarationToolsTests.assertEquals(null, (String)TypeDeclarationTools.componentTypeDeclaration((String)"int"));
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.componentTypeDeclaration((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((String)"int[][]", (String)TypeDeclarationTools.componentTypeDeclaration((String)"int[][][]"));
        TypeDeclarationToolsTests.assertEquals(null, (String)TypeDeclarationTools.componentTypeDeclaration((String)"float"));
        TypeDeclarationToolsTests.assertEquals((String)"float", (String)TypeDeclarationTools.componentTypeDeclaration((String)"float [ ]"));
        TypeDeclarationToolsTests.assertEquals((String)"float[][]", (String)TypeDeclarationTools.componentTypeDeclaration((String)"float[] [] []"));
    }

    public void testComponentTypeDeclarationCharArray() throws Exception {
        TestTools.assertEquals(null, TypeDeclarationTools.componentTypeDeclaration((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("java.lang.Object", TypeDeclarationTools.componentTypeDeclaration((char[])"java.lang.Object[]".toCharArray()));
        TestTools.assertEquals("java.lang.Object[][]", TypeDeclarationTools.componentTypeDeclaration((char[])"java.lang.Object[][][]".toCharArray()));
        TestTools.assertEquals(null, TypeDeclarationTools.componentTypeDeclaration((char[])"int".toCharArray()));
        TestTools.assertEquals("int", TypeDeclarationTools.componentTypeDeclaration((char[])"int[]".toCharArray()));
        TestTools.assertEquals("int[][]", TypeDeclarationTools.componentTypeDeclaration((char[])"int[][][]".toCharArray()));
        TestTools.assertEquals(null, TypeDeclarationTools.componentTypeDeclaration((char[])"float".toCharArray()));
        TestTools.assertEquals("float", TypeDeclarationTools.componentTypeDeclaration((char[])"float [ ]".toCharArray()));
        TestTools.assertEquals("float[][]", TypeDeclarationTools.componentTypeDeclaration((char[])"float[] [] []".toCharArray()));
    }

    public void testClassNameString() throws Exception {
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.className((String)"int"));
        TypeDeclarationToolsTests.assertEquals((String)"[I", (String)TypeDeclarationTools.className((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((String)"[[I", (String)TypeDeclarationTools.className((String)"int [ ] [ ]"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang.Object", (String)TypeDeclarationTools.className((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((String)"[Ljava.lang.Object;", (String)TypeDeclarationTools.className((String)"java.lang.Object\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"[[Ljava.lang.Object;", (String)TypeDeclarationTools.className((String)"java.lang.Object\t[]\t[]"));
    }

    public void testClassNameCharArray() throws Exception {
        TestTools.assertEquals("int", TypeDeclarationTools.className((char[])"int".toCharArray()));
        TestTools.assertEquals("[I", TypeDeclarationTools.className((char[])"int[]".toCharArray()));
        TestTools.assertEquals("[[I", TypeDeclarationTools.className((char[])"int [ ] [ ]".toCharArray()));
        TestTools.assertEquals("java.lang.Object", TypeDeclarationTools.className((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("[Ljava.lang.Object;", TypeDeclarationTools.className((char[])"java.lang.Object\t[]".toCharArray()));
        TestTools.assertEquals("[[Ljava.lang.Object;", TypeDeclarationTools.className((char[])"java.lang.Object\t[]\t[]".toCharArray()));
    }

    public void testClassNameStringInt() throws Exception {
        TypeDeclarationToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)TypeDeclarationTools.className((String)"int", (int)0));
        TypeDeclarationToolsTests.assertEquals((String)int[].class.getName(), (String)TypeDeclarationTools.className((String)"int", (int)1));
        TypeDeclarationToolsTests.assertEquals((String)int[][][].class.getName(), (String)TypeDeclarationTools.className((String)"int", (int)3));
        TypeDeclarationToolsTests.assertEquals((String)Object.class.getName(), (String)TypeDeclarationTools.className((String)"java.lang.Object", (int)0));
        TypeDeclarationToolsTests.assertEquals((String)Object[][][].class.getName(), (String)TypeDeclarationTools.className((String)"java.lang.Object", (int)3));
        TypeDeclarationToolsTests.assertEquals((String)Void.TYPE.getName(), (String)TypeDeclarationTools.className((String)"void", (int)0));
        try {
            TypeDeclarationTools.className((String)Void.TYPE.getName(), (int)1);
            TypeDeclarationToolsTests.fail((String)"should not get here...");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testClassNameCharArrayInt() throws Exception {
        TestTools.assertEquals(Integer.TYPE.getName(), TypeDeclarationTools.className((char[])"int".toCharArray(), (int)0));
        TestTools.assertEquals(int[].class.getName(), TypeDeclarationTools.className((char[])"int".toCharArray(), (int)1));
        TestTools.assertEquals(int[][][].class.getName(), TypeDeclarationTools.className((char[])"int".toCharArray(), (int)3));
        TestTools.assertEquals(Object.class.getName(), TypeDeclarationTools.className((char[])"java.lang.Object".toCharArray(), (int)0));
        TestTools.assertEquals(Object[][][].class.getName(), TypeDeclarationTools.className((char[])"java.lang.Object".toCharArray(), (int)3));
        TestTools.assertEquals(Void.TYPE.getName(), TypeDeclarationTools.className((char[])"void".toCharArray(), (int)0));
        try {
            TypeDeclarationTools.className((char[])Void.TYPE.getName().toCharArray(), (int)1);
            TypeDeclarationToolsTests.fail((String)"should not get here...");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testSimpleNameString() throws Exception {
        TypeDeclarationToolsTests.assertEquals((String)"int", (String)TypeDeclarationTools.simpleName((String)"int"));
        TypeDeclarationToolsTests.assertEquals((String)"int[]", (String)TypeDeclarationTools.simpleName((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((String)"int[][]", (String)TypeDeclarationTools.simpleName((String)"int [ ] [ ]"));
        TypeDeclarationToolsTests.assertEquals((String)"Object", (String)TypeDeclarationTools.simpleName((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((String)"Object[]", (String)TypeDeclarationTools.simpleName((String)"java.lang.Object\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"Object[][]", (String)TypeDeclarationTools.simpleName((String)"java.lang.Object\t[]\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"Default", (String)TypeDeclarationTools.simpleName((String)"Default"));
        TypeDeclarationToolsTests.assertEquals((String)"Default[]", (String)TypeDeclarationTools.simpleName((String)"Default\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"Default[][]", (String)TypeDeclarationTools.simpleName((String)"Default\t[]\t[]"));
    }

    public void testSimpleNameCharArray() throws Exception {
        TestTools.assertEquals("int", TypeDeclarationTools.simpleName((char[])"int".toCharArray()));
        TestTools.assertEquals("int[]", TypeDeclarationTools.simpleName((char[])"int[]".toCharArray()));
        TestTools.assertEquals("int[][]", TypeDeclarationTools.simpleName((char[])"int [ ] [ ]".toCharArray()));
        TestTools.assertEquals("Object", TypeDeclarationTools.simpleName((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("Object[]", TypeDeclarationTools.simpleName((char[])"java.lang.Object\t[]".toCharArray()));
        TestTools.assertEquals("Object[][]", TypeDeclarationTools.simpleName((char[])"java.lang.Object\t[]\t[]".toCharArray()));
        TestTools.assertEquals("Default", TypeDeclarationTools.simpleName((char[])"Default".toCharArray()));
        TestTools.assertEquals("Default[]", TypeDeclarationTools.simpleName((char[])"Default\t[]".toCharArray()));
        TestTools.assertEquals("Default[][]", TypeDeclarationTools.simpleName((char[])"Default\t[]\t[]".toCharArray()));
    }

    public void testPackageNameString() throws Exception {
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"int"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"int [ ] [ ]"));
        TypeDeclarationToolsTests.assertEquals((String)"java.lang", (String)TypeDeclarationTools.packageName((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"java.lang.Object\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"java.lang.Object\t[]\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"Default"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"Default\t[]"));
        TypeDeclarationToolsTests.assertEquals((String)"", (String)TypeDeclarationTools.packageName((String)"Default\t[]\t[]"));
    }

    public void testPackageNameCharArray() throws Exception {
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"int".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"int[]".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"int [ ] [ ]".toCharArray()));
        TestTools.assertEquals("java.lang", TypeDeclarationTools.packageName((char[])"java.lang.Object".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"java.lang.Object\t[]".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"java.lang.Object\t[]\t[]".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"Default".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"Default\t[]".toCharArray()));
        TestTools.assertEquals("", TypeDeclarationTools.packageName((char[])"Default\t[]\t[]".toCharArray()));
    }

    public void testLoadClassString() throws Exception {
        TypeDeclarationToolsTests.assertEquals(Integer.TYPE, (Object)TypeDeclarationTools.loadClass((String)"int"));
        TypeDeclarationToolsTests.assertEquals(int[].class, (Object)TypeDeclarationTools.loadClass((String)"int[]"));
        TypeDeclarationToolsTests.assertEquals(int[][].class, (Object)TypeDeclarationTools.loadClass((String)"int [ ] [ ]"));
        TypeDeclarationToolsTests.assertEquals(Object.class, (Object)TypeDeclarationTools.loadClass((String)"java.lang.Object"));
        TypeDeclarationToolsTests.assertEquals(Object[].class, (Object)TypeDeclarationTools.loadClass((String)"java.lang.Object\t[]"));
        TypeDeclarationToolsTests.assertEquals(Object[][].class, (Object)TypeDeclarationTools.loadClass((String)"java.lang.Object\t[]\t[]"));
    }

    public void testLoadClassCharArray() throws Exception {
        TypeDeclarationToolsTests.assertEquals(Integer.TYPE, (Object)TypeDeclarationTools.loadClass((char[])"int".toCharArray()));
        TypeDeclarationToolsTests.assertEquals(int[].class, (Object)TypeDeclarationTools.loadClass((char[])"int[]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals(int[][].class, (Object)TypeDeclarationTools.loadClass((char[])"int [ ] [ ]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals(Object.class, (Object)TypeDeclarationTools.loadClass((char[])"java.lang.Object".toCharArray()));
        TypeDeclarationToolsTests.assertEquals(Object[].class, (Object)TypeDeclarationTools.loadClass((char[])"java.lang.Object\t[]".toCharArray()));
        TypeDeclarationToolsTests.assertEquals(Object[][].class, (Object)TypeDeclarationTools.loadClass((char[])"java.lang.Object\t[]\t[]".toCharArray()));
    }

    public void testIsJavaLangClassString() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((String)"Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((String)"String"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((String)"AutoCloseable"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((String)"FunctionalInterface"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass((String)""));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass((String)"Collection"));
    }

    public void testIsJavaLangClassCharArray() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((char[])"Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((char[])"String".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((char[])"AutoCloseable".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass((char[])"FunctionalInterface".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass((char[])"".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass((char[])"Collection".toCharArray()));
    }

    public void testIsJavaLangClass5String() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass5((String)"Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass5((String)"String"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((String)"AutoCloseable"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((String)"FunctionalInterface"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((String)""));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((String)"Collection"));
    }

    public void testIsJavaLangClass5CharArray() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"String".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"AutoCloseable".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"FunctionalInterface".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass5((char[])"Collection".toCharArray()));
    }

    public void testIsJavaLangClass6String() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass6((String)"Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass6((String)"String"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((String)"AutoCloseable"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((String)"FunctionalInterface"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((String)""));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((String)"Collection"));
    }

    public void testIsJavaLangClass6CharArray() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"String".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"AutoCloseable".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"FunctionalInterface".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass6((char[])"Collection".toCharArray()));
    }

    public void testIsJavaLangClass7String() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((String)"Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((String)"String"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((String)"AutoCloseable"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((String)"FunctionalInterface"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((String)""));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((String)"Collection"));
    }

    public void testIsJavaLangClass7CharArray() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"String".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"AutoCloseable".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"FunctionalInterface".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass7((char[])"Collection".toCharArray()));
    }

    public void testIsJavaLangClass8String() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((String)"Object"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((String)"String"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((String)"AutoCloseable"));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((String)"FunctionalInterface"));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass8((String)""));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass8((String)"Collection"));
    }

    public void testIsJavaLangClass8CharArray() {
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"Object".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"String".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"AutoCloseable".toCharArray()));
        TypeDeclarationToolsTests.assertTrue((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"FunctionalInterface".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"".toCharArray()));
        TypeDeclarationToolsTests.assertFalse((boolean)TypeDeclarationTools.isJavaLangClass8((char[])"Collection".toCharArray()));
    }

    public void testJDKVersion() {
        TypeDeclarationToolsTests.assertTrue((String)"update TypeDeclarationTools.JAVA_LANG_CLASS_NAMES for new JDK...", (boolean)SystemTools.javaSpecificationVersionIsLessThanOrEqualTo((String)"1.8"));
    }
}

