/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSJ2EEUtils
extends JAXRSUtils {
    public static WebArtifactEdit getWebArtifactEditForWrite(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
    }

    public static WebArtifactEdit getWebArtifactEditForRead(IProject project) {
        return WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Servlet findJAXRSServletUsingLibraryProviderID(Object webApp, String selectedLibraryProviderID) {
        Iterator it = null;
        Servlet toReturn = null;
        if (webApp == null) {
            return null;
        }
        if (!(webApp instanceof org.eclipse.jst.j2ee.webapplication.WebApp)) {
            return null;
        }
        for (Servlet servlet : ((org.eclipse.jst.j2ee.webapplication.WebApp)webApp).getServlets()) {
            for (Description desc : servlet.getDescriptions()) {
                String value = desc.getValue();
                if (value == null || !value.trim().startsWith("JAX-RS Tools Generated")) continue;
                return servlet;
            }
            if (servlet == null || servlet.getWebType() == null) continue;
            if (servlet.getWebType().isServletType()) {
                if (servlet.getServletName() != null && (servlet.getServletName().trim().equals(JAXRSJ2EEUtils.getSavedservletName()) || servlet.getServletName().trim().equals("JAX-RS Servlet"))) {
                    return servlet;
                }
                if (((ServletType)servlet.getWebType()).getClassName() != null && ((ServletType)servlet.getWebType()).getClassName().trim().equals(JAXRSJ2EEUtils.getSavedServletClassName(selectedLibraryProviderID))) {
                    return servlet;
                }
                if (((ServletType)servlet.getWebType()).getClassName() != null && JAXRSJ2EEUtils.facetKnowsServletClassName(((ServletType)servlet.getWebType()).getClassName().trim())) {
                    return servlet;
                }
                if (((ServletType)servlet.getWebType()).getClassName() == null || !((ServletType)servlet.getWebType()).getClassName().trim().equals("") || toReturn != null) continue;
                toReturn = servlet;
                continue;
            }
            if (!servlet.getWebType().isJspType() || ((JSPType)servlet.getWebType()).getJspFile() == null || !((JSPType)servlet.getWebType()).getJspFile().trim().equals("") && !((JSPType)servlet.getWebType()).getJspFile().trim().equals(JAXRSJ2EEUtils.getSavedservletName())) continue;
            return servlet;
        }
        return toReturn;
    }

    public static Servlet findJAXRSServlet(Object webApp, String selectedLibraryProviderID) {
        return JAXRSJ2EEUtils.findJAXRSServletUsingLibraryProviderID(webApp, selectedLibraryProviderID);
    }

    public static Servlet findJAXRSServlet(Object webApp) {
        return JAXRSJ2EEUtils.findJAXRSServletUsingLibraryProviderID(webApp, null);
    }

    public static Servlet createOrUpdateServletRef(org.eclipse.jst.j2ee.webapplication.WebApp webApp, IDataModel config, Servlet servlet) {
        String displayName = JAXRSJ2EEUtils.getDisplayName(config);
        String className = JAXRSJ2EEUtils.getServletClassname(config);
        if (className == null || className.trim().length() == 0) {
            className = "";
        }
        return JAXRSJ2EEUtils.createOrUpdateServletRef(webApp, displayName, className, servlet);
    }

    public static Servlet createOrUpdateServletRef(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String displayName, String className, Servlet servlet) {
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(displayName);
            servlet.setDescription("JAX-RS Tools Generated - Do not modify");
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(Integer.valueOf(1));
            webApp.getServlets().add((Object)servlet);
        } else {
            JAXRSJ2EEUtils.updateServletMappings(webApp, servlet, servlet.getServletName().trim(), displayName);
            servlet.setServletName(displayName);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(Integer.valueOf(1));
            Description jaxrsToolsDescription = null;
            Description next2 = null;
            EList descriptions = servlet.getDescriptions();
            if (descriptions != null) {
                for (Description next2 : descriptions) {
                    if (!"JAX-RS Tools Generated - Do not modify".equals(next2.getValue())) continue;
                    jaxrsToolsDescription = next2;
                    break;
                }
            }
            if (jaxrsToolsDescription == null) {
                servlet.setDescription("JAX-RS Tools Generated - Do not modify");
            }
        }
        return servlet;
    }

    private static void updateServletMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String servletName, String newServletName) {
        List<ServletMapping> mappings = JAXRSJ2EEUtils.findServletMappings(webApp, servlet, servletName);
        for (ServletMapping map : mappings) {
            map.setName(newServletName);
        }
    }

    private static List<ServletMapping> findServletMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String servletName) {
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        EList allMappings = webApp.getServletMappings();
        int i = allMappings.size() - 1;
        while (i >= 0) {
            ServletMapping mapping = (ServletMapping)allMappings.get(i);
            if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                mappings.add(mapping);
            }
            --i;
        }
        return mappings;
    }

    public static boolean isWebApp25(Object webApp) {
        return webApp instanceof WebApp;
    }

    public static void setUpURLMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, List urlMappingList, Servlet servlet) {
        for (String pattern : urlMappingList) {
            if (JAXRSJ2EEUtils.doesServletMappingExist(webApp, servlet, pattern)) continue;
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(pattern);
            webApp.getServletMappings().add((Object)mapping);
        }
    }

    public static void updateURLMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, List urlMappingList, Servlet servlet) {
        if (urlMappingList != null) {
            List<ServletMapping> mappings = JAXRSJ2EEUtils.findServletMappings(webApp, servlet, servlet.getServletName());
            for (String pattern : urlMappingList) {
                if (JAXRSJ2EEUtils.doesServletMappingExist(webApp, servlet, pattern)) continue;
                ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
                mapping.setServlet(servlet);
                mapping.setName(servlet.getServletName());
                mapping.setUrlPattern(pattern);
                webApp.getServletMappings().add((Object)mapping);
            }
            ArrayList<ServletMapping> patternsToRemove = new ArrayList<ServletMapping>();
            for (ServletMapping next : mappings) {
                String patternTypeValue = next.getUrlPattern();
                if (patternTypeValue == null || urlMappingList.contains(patternTypeValue)) continue;
                patternsToRemove.add(next);
            }
            Iterator<Object> iter = patternsToRemove.iterator();
            while (iter.hasNext()) {
                webApp.getServletMappings().remove(iter.next());
            }
        }
    }

    private static boolean doesServletMappingExist(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet, String pattern) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName) && mapping.getUrlPattern() != null && mapping.getUrlPattern().trim().equals(pattern)) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    public static void removeURLMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
        EList mappings = webApp.getServletMappings();
        String servletName = servlet.getServletName();
        if (servletName != null) {
            int i = mappings.size() - 1;
            while (i >= 0) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping != null && mapping.getServlet() != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                    mappings.remove(mapping);
                }
                --i;
            }
        }
    }

    public static boolean isWebApp24(Object webAppObj) {
        return webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp && ((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj).getVersionID() == 24;
    }

    public static boolean isWebApp23(Object webAppObj) {
        return webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp && ((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj).getVersionID() == 23;
    }
}

