/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.ArrayToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.collection.MapToolsTests;

public class IterableToolsTests
extends TestCase {
    public IterableToolsTests(String name) {
        super(name);
    }

    public void testContainsIterableObject() {
        List<String> c;
        List<String> iterable = c = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.contains(iterable, (Object)"one"));
        IterableToolsTests.assertFalse((boolean)IterableTools.contains(iterable, null));
        c.add(null);
        IterableToolsTests.assertTrue((boolean)IterableTools.contains(iterable, null));
    }

    public void testCountIterableObject() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.count((Iterable)c, (Object)one));
        c.add("one");
        IterableToolsTests.assertEquals((int)2, (int)IterableTools.count((Iterable)c, (Object)one));
        IterableToolsTests.assertEquals((int)0, (int)IterableTools.count((Iterable)c, null));
        c.add(null);
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.count((Iterable)c, null));
        c.add(null);
        IterableToolsTests.assertEquals((int)2, (int)IterableTools.count((Iterable)c, null));
    }

    public void testCountFalseIteratorPredicate() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        IterableToolsTests.assertEquals((int)4, (int)IterableTools.countFalse((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(0)));
        IterableToolsTests.assertEquals((int)2, (int)IterableTools.countFalse((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(3)));
        c.add("foo");
        IterableToolsTests.assertEquals((int)2, (int)IterableTools.countFalse((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(3)));
    }

    public void testCountTrueIteratorPredicate() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        IterableToolsTests.assertEquals((int)0, (int)IterableTools.countTrue((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(0)));
        IterableToolsTests.assertEquals((int)2, (int)IterableTools.countTrue((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(3)));
        c.add("foo");
        IterableToolsTests.assertEquals((int)3, (int)IterableTools.countTrue((Iterable)c, (Predicate)new MapToolsTests.StringLengthPredicate(3)));
    }

    public void testContainsAllIterableCollection() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, this.buildStringList1()));
    }

    public void testContainsAllIterableIntCollection() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, (int)3, this.buildStringList1()));
    }

    public void testContainsAllIterableIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable1, iterable2));
    }

    public void testContainsAllIterableIntIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable1, (int)3, iterable2));
    }

    public void testContainsAllIterableIterator() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableIntIterator() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, (int)3, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableObjectArray() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        IterableToolsTests.assertFalse((boolean)IterableTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllIterableIntObjectArray() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertTrue((boolean)IterableTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        IterableToolsTests.assertFalse((boolean)IterableTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
    }

    public void testElementsAreDifferentIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList list2 = new ArrayList();
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreDifferent(list1, list2));
        IterableToolsTests.assertFalse((boolean)IterableTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreEqualIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        IterableToolsTests.assertFalse((boolean)IterableTools.elementsAreIdentical(list1, list2));
        IterableToolsTests.assertFalse((boolean)IterableTools.elementsAreDifferent(list1, list2));
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreIdenticalIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> iterable1 = list1;
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        ArrayList<String> iterable2 = list2;
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreIdentical(iterable1, iterable2));
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(iterable1, iterable2));
    }

    public void testElementsAreNotIdenticalIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> iterable1 = list1;
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        ArrayList<String> iterable2 = list2;
        IterableToolsTests.assertFalse((boolean)IterableTools.elementsAreNotIdentical(iterable1, iterable2));
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(iterable1, iterable2));
    }

    public void testExecuteParmCommand() {
        List<String> list = this.buildStringList1();
        ArrayToolsTests.ConcatenateClosure closure = new ArrayToolsTests.ConcatenateClosure();
        IterableTools.execute(list, (Closure)closure);
        IterableToolsTests.assertEquals((String)"zeroonetwo", (String)closure.string);
    }

    public void testExecuteInterruptibleParmCommand() throws Exception {
        List<String> list = this.buildStringList1();
        ArrayToolsTests.InterruptibleConcatenateClosure closure = new ArrayToolsTests.InterruptibleConcatenateClosure();
        IterableTools.execute(list, (InterruptibleClosure)closure);
        IterableToolsTests.assertEquals((String)"zeroonetwo", (String)closure.string);
    }

    public void testGetIterableInt() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        String o = (String)IterableTools.get(iterable, (int)1);
        IterableToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)IterableTools.get(iterable, (int)3);
        IterableToolsTests.assertNull((Object)o);
    }

    public void testHashCodeIterable1() {
        Iterable iterable = null;
        IterableToolsTests.assertEquals((int)0, (int)IterableTools.hashCode(iterable));
    }

    public void testHashCodeIterable2() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        int hashCode = IterableTools.hashCode(iterable);
        IterableToolsTests.assertEquals((int)list.hashCode(), (int)hashCode);
        list.add(null);
        hashCode = IterableTools.hashCode(iterable);
        IterableToolsTests.assertEquals((int)list.hashCode(), (int)hashCode);
    }

    public void testIndexOfIterableObject_String() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.indexOf(iterable, (Object)"one"));
    }

    public void testIndexOfIterableObjectInt() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.indexOf(iterable, (Object)"one", (int)-11));
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.indexOf(iterable, (Object)"one", (int)1));
        IterableToolsTests.assertEquals((int)-1, (int)IterableTools.indexOf(iterable, (Object)"one", (int)2));
        IterableToolsTests.assertEquals((int)-1, (int)IterableTools.indexOf(iterable, (Object)"one", (int)22));
    }

    public void testIsEmptyIterable() {
        IterableToolsTests.assertFalse((boolean)IterableTools.isEmpty(this.buildObjectList1()));
        IterableToolsTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)EmptyIterable.instance()));
    }

    public void testIterableObjectArray() {
        Object[] strings = this.buildStringArray1();
        int i = 0;
        for (String string : IterableTools.iterable((Object[])strings)) {
            IterableToolsTests.assertEquals((String)strings[i++], (String)string);
        }
    }

    public void testLastIterable1() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        IterableToolsTests.assertEquals((String)"two", (String)((String)IterableTools.last(iterable)));
        list.add(null);
        IterableToolsTests.assertEquals(null, (String)((String)IterableTools.last(iterable)));
    }

    public void testLastIterable2() {
        ArrayList iterable = new ArrayList();
        boolean exCaught = false;
        try {
            IterableTools.last(iterable);
            IterableToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IterableToolsTests.assertTrue((boolean)exCaught);
    }

    public void testLastIndexOfIterableObject() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.lastIndexOf(iterable, (Object)"one"));
        list.add(null);
        IterableToolsTests.assertEquals((int)(list.size() - 1), (int)IterableTools.lastIndexOf(iterable, null));
    }

    public void testLastIndexOfIterableObjectInt() {
        List<String> iterable = this.buildStringList1();
        IterableToolsTests.assertEquals((int)-1, (int)IterableTools.lastIndexOf(iterable, (Object)"one", (int)-11));
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.lastIndexOf(iterable, (Object)"one", (int)1));
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.lastIndexOf(iterable, (Object)"one", (int)2));
        IterableToolsTests.assertEquals((int)1, (int)IterableTools.lastIndexOf(iterable, (Object)"one", (int)22));
    }

    public void testSizeIterable() {
        List<Object> iterable = this.buildObjectList1();
        IterableToolsTests.assertEquals((int)3, (int)IterableTools.size(iterable));
    }

    public void testSortIterable() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = IterableTools.sort(iterable1);
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = IterableTools.sort(iterable1, (int)77);
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = IterableTools.sort(iterable1, (Comparator)ComparatorTools.reverseComparator());
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = IterableTools.sort(iterable1, (Comparator)ComparatorTools.reverseComparator(), (int)77);
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testTransformIterableTransformer() {
        List<String> list = Arrays.asList("zero", "one", "two");
        Iterable actual = IterableTools.transform(list, ArrayToolsTests.UPPER_CASE_TRANSFORMER);
        List<Object> expected = Arrays.asList("ZERO", "ONE", "TWO");
        IterableToolsTests.assertTrue((boolean)IterableTools.elementsAreEqual(expected, (Iterable)actual));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(IterableTools.class);
                IterableToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        IterableToolsTests.assertTrue((boolean)exCaught);
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }
}

