/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.util.IFilter;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionDialog;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PresetSelectionPanel
extends Composite {
    private final Group group;
    private final Combo presetsCombo;
    private final Button modifyButton;
    private final Text descTextField;
    private final IFacetedProjectWorkingCopy fpjwc;

    public PresetSelectionPanel(Composite parent, IFacetedProjectWorkingCopy fpjwc) {
        this(parent, fpjwc, null);
    }

    public PresetSelectionPanel(Composite parent, IFacetedProjectWorkingCopy fpjwc, IFilter<IPreset> filter) {
        super(parent, 0);
        Dialog.applyDialogFont((Control)parent);
        this.fpjwc = fpjwc;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.group = new Group((Composite)this, 0);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.group.setText(Resources.groupTitle);
        this.presetsCombo = new Combo((Composite)this.group, 2056);
        this.presetsCombo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.modifyButton = new Button((Composite)this.group, 8);
        this.modifyButton.setText(Resources.modifyButtonLabel);
        GridDataFactory.defaultsFor((Control)this.modifyButton).applyTo((Control)this.modifyButton);
        this.modifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PresetSelectionPanel.this.handleModifyButtonPressed();
            }
        });
        this.descTextField = new Text((Composite)this.group, 72);
        GridData gd = GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2);
        gd.widthHint = 400;
        gd.minimumHeight = 30;
        this.descTextField.setLayoutData((Object)gd);
        this.fpjwc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        PresetSelectionPanel.this.refreshDescription();
                    }
                };
                Display.getDefault().asyncExec(runnable);
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED});
        ModifyFacetedProjectWizard.syncWithPresetsModel(this.fpjwc, this.presetsCombo, filter);
    }

    private void refreshDescription() {
        int currentHeight;
        IPreset preset = this.fpjwc.getSelectedPreset();
        String desc = preset == null ? Resources.hint : preset.getDescription();
        this.descTextField.setText(desc);
        ((GridData)this.descTextField.getLayoutData()).minimumHeight = currentHeight = this.descTextField.getSize().y;
        Shell shell = this.getShell();
        shell.layout(true, true);
        Point currentSize = shell.getSize();
        Point preferredSize = shell.computeSize(currentSize.x - 30, -1);
        if (preferredSize.y > currentSize.y) {
            shell.setSize(currentSize.x, preferredSize.y);
        }
    }

    private void handleModifyButtonPressed() {
        FacetsSelectionDialog.openDialog(this.getShell(), this.fpjwc);
    }

    private static final class Resources
    extends NLS {
        public static String groupTitle;
        public static String hint;
        public static String modifyButtonLabel;

        static {
            Resources.initializeMessages((String)PresetSelectionPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

